/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.signers;

import java.io.IOException;
import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoServicesRegistrar;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Signer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.digests.SM3Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECDomainParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithID;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.signers.DSAKCalculator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.signers.RandomDSAKCalculator;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECAlgorithms;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECConstants;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECFieldElement;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECMultiplier;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.FixedPointCombMultiplier;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.encoders.Hex;

public class SM2Signer
implements Signer,
ECConstants {
    private final DSAKCalculator kCalculator = new RandomDSAKCalculator();
    private final SM3Digest digest = new SM3Digest();
    private ECDomainParameters ecParams;
    private ECPoint pubPoint;
    private ECKeyParameters ecKey;
    private byte[] z;

    public void init(boolean bl2, CipherParameters cipherParameters) {
        byte[] byArray;
        CipherParameters cipherParameters2;
        if (cipherParameters instanceof ParametersWithID) {
            cipherParameters2 = ((ParametersWithID)cipherParameters).getParameters();
            byArray = ((ParametersWithID)cipherParameters).getID();
        } else {
            cipherParameters2 = cipherParameters;
            byArray = Hex.decode((String)"31323334353637383132333435363738");
        }
        if (bl2) {
            if (cipherParameters2 instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters2;
                this.ecKey = (ECKeyParameters)parametersWithRandom.getParameters();
                this.ecParams = this.ecKey.getParameters();
                this.kCalculator.init(this.ecParams.getN(), parametersWithRandom.getRandom());
            } else {
                this.ecKey = (ECKeyParameters)cipherParameters2;
                this.ecParams = this.ecKey.getParameters();
                this.kCalculator.init(this.ecParams.getN(), CryptoServicesRegistrar.getSecureRandom());
            }
            this.pubPoint = this.createBasePointMultiplier().multiply(this.ecParams.getG(), ((ECPrivateKeyParameters)this.ecKey).getD()).normalize();
        } else {
            this.ecKey = (ECKeyParameters)cipherParameters2;
            this.ecParams = this.ecKey.getParameters();
            this.pubPoint = ((ECPublicKeyParameters)this.ecKey).getQ();
        }
        this.z = this.getZ(byArray);
        this.digest.update(this.z, 0, this.z.length);
    }

    public void update(byte by2) {
        this.digest.update(by2);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.digest.update(byArray, n2, n3);
    }

    public boolean verifySignature(byte[] byArray) {
        try {
            BigInteger[] bigIntegerArray = this.derDecode(byArray);
            if (bigIntegerArray != null) {
                return this.verifySignature(bigIntegerArray[0], bigIntegerArray[1]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public void reset() {
        this.digest.reset();
        if (this.z != null) {
            this.digest.update(this.z, 0, this.z.length);
        }
    }

    public byte[] generateSignature() throws CryptoException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        byte[] byArray = this.digestDoFinal();
        BigInteger bigInteger3 = this.ecParams.getN();
        BigInteger bigInteger4 = this.calculateE(byArray);
        BigInteger bigInteger5 = ((ECPrivateKeyParameters)this.ecKey).getD();
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        while (true) {
            BigInteger bigInteger6 = this.kCalculator.nextK();
            Object object = eCMultiplier.multiply(this.ecParams.getG(), bigInteger6).normalize();
            bigInteger2 = bigInteger4.add(object.getAffineXCoord().toBigInteger()).mod(bigInteger3);
            if (bigInteger2.equals(ZERO) || bigInteger2.add(bigInteger6).equals(bigInteger3)) continue;
            object = bigInteger5.add(ONE).modInverse(bigInteger3);
            bigInteger = bigInteger6.subtract(bigInteger2.multiply(bigInteger5)).mod(bigInteger3);
            if (!(bigInteger = ((BigInteger)object).multiply(bigInteger).mod(bigInteger3)).equals(ZERO)) break;
        }
        try {
            return this.derEncode(bigInteger2, bigInteger);
        }
        catch (IOException iOException) {
            throw new CryptoException("unable to encode signature: " + iOException.getMessage(), (Throwable)iOException);
        }
    }

    private boolean verifySignature(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = this.ecParams.getN();
        if (bigInteger.compareTo(ONE) < 0 || bigInteger.compareTo(bigInteger3) >= 0) {
            return false;
        }
        if (bigInteger2.compareTo(ONE) < 0 || bigInteger2.compareTo(bigInteger3) >= 0) {
            return false;
        }
        byte[] byArray = this.digestDoFinal();
        BigInteger bigInteger4 = this.calculateE(byArray);
        BigInteger bigInteger5 = bigInteger.add(bigInteger2).mod(bigInteger3);
        if (bigInteger5.equals(ZERO)) {
            return false;
        }
        ECPoint eCPoint = ((ECPublicKeyParameters)this.ecKey).getQ();
        ECPoint eCPoint2 = ECAlgorithms.sumOfTwoMultiplies((ECPoint)this.ecParams.getG(), (BigInteger)bigInteger2, (ECPoint)eCPoint, (BigInteger)bigInteger5).normalize();
        if (eCPoint2.isInfinity()) {
            return false;
        }
        BigInteger bigInteger6 = bigInteger4.add(eCPoint2.getAffineXCoord().toBigInteger()).mod(bigInteger3);
        return bigInteger6.equals(bigInteger);
    }

    private byte[] digestDoFinal() {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        this.reset();
        return byArray;
    }

    private byte[] getZ(byte[] byArray) {
        this.digest.reset();
        this.addUserID((Digest)this.digest, byArray);
        this.addFieldElement((Digest)this.digest, this.ecParams.getCurve().getA());
        this.addFieldElement((Digest)this.digest, this.ecParams.getCurve().getB());
        this.addFieldElement((Digest)this.digest, this.ecParams.getG().getAffineXCoord());
        this.addFieldElement((Digest)this.digest, this.ecParams.getG().getAffineYCoord());
        this.addFieldElement((Digest)this.digest, this.pubPoint.getAffineXCoord());
        this.addFieldElement((Digest)this.digest, this.pubPoint.getAffineYCoord());
        byte[] byArray2 = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray2, 0);
        return byArray2;
    }

    private void addUserID(Digest digest, byte[] byArray) {
        int n2 = byArray.length * 8;
        digest.update((byte)(n2 >> 8 & 0xFF));
        digest.update((byte)(n2 & 0xFF));
        digest.update(byArray, 0, byArray.length);
    }

    private void addFieldElement(Digest digest, ECFieldElement eCFieldElement) {
        byte[] byArray = eCFieldElement.getEncoded();
        digest.update(byArray, 0, byArray.length);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    protected BigInteger calculateE(byte[] byArray) {
        return new BigInteger(1, byArray);
    }

    protected BigInteger[] derDecode(byte[] byArray) throws IOException {
        BigInteger bigInteger;
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)ASN1Primitive.fromByteArray((byte[])byArray));
        if (aSN1Sequence.size() != 2) {
            return null;
        }
        BigInteger bigInteger2 = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(0)).getValue();
        byte[] byArray2 = this.derEncode(bigInteger2, bigInteger = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(1)).getValue());
        if (!Arrays.constantTimeAreEqual((byte[])byArray2, (byte[])byArray)) {
            return null;
        }
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    protected byte[] derEncode(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(bigInteger));
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(bigInteger2));
        return new DERSequence(aSN1EncodableVector).getEncoded("DER");
    }
}

