/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.parsers;

import java.io.IOException;
import java.io.InputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.KeyParser;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AsymmetricKeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECDomainParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.io.Streams;

public class ECIESPublicKeyParser
implements KeyParser {
    private ECDomainParameters ecParams;

    public ECIESPublicKeyParser(ECDomainParameters eCDomainParameters) {
        this.ecParams = eCDomainParameters;
    }

    public AsymmetricKeyParameter readKey(InputStream inputStream) throws IOException {
        byte[] byArray;
        int n2 = inputStream.read();
        switch (n2) {
            case 0: {
                throw new IOException("Sender's public key invalid.");
            }
            case 2: 
            case 3: {
                byArray = new byte[1 + (this.ecParams.getCurve().getFieldSize() + 7) / 8];
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                byArray = new byte[1 + 2 * ((this.ecParams.getCurve().getFieldSize() + 7) / 8)];
                break;
            }
            default: {
                throw new IOException("Sender's public key has invalid point encoding 0x" + Integer.toString(n2, 16));
            }
        }
        byArray[0] = (byte)n2;
        Streams.readFully((InputStream)inputStream, (byte[])byArray, (int)1, (int)(byArray.length - 1));
        return new ECPublicKeyParameters(this.ecParams.getCurve().decodePoint(byArray), this.ecParams);
    }
}

