/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.paddings;

import java.security.SecureRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoServicesRegistrar;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.InvalidCipherTextException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.paddings.BlockCipherPadding;

public class ISO10126d2Padding
implements BlockCipherPadding {
    SecureRandom random;

    public void init(SecureRandom secureRandom) throws IllegalArgumentException {
        this.random = secureRandom != null ? secureRandom : CryptoServicesRegistrar.getSecureRandom();
    }

    public String getPaddingName() {
        return "ISO10126-2";
    }

    public int addPadding(byte[] byArray, int n2) {
        byte by2 = (byte)(byArray.length - n2);
        while (n2 < byArray.length - 1) {
            byArray[n2] = (byte)this.random.nextInt();
            ++n2;
        }
        byArray[n2] = by2;
        return by2;
    }

    public int padCount(byte[] byArray) throws InvalidCipherTextException {
        int n2 = byArray[byArray.length - 1] & 0xFF;
        if (n2 > byArray.length) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return n2;
    }
}

