/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.gcm;

import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.gcm.GCMMultiplier;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.gcm.GCMUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Pack;

public class Tables64kGCMMultiplier
implements GCMMultiplier {
    private byte[] H;
    private long[][][] T;

    public void init(byte[] byArray) {
        if (this.T == null) {
            this.T = new long[16][256][2];
        } else if (Arrays.areEqual((byte[])this.H, (byte[])byArray)) {
            return;
        }
        this.H = Arrays.clone((byte[])byArray);
        for (int i2 = 0; i2 < 16; ++i2) {
            long[][] lArray = this.T[i2];
            if (i2 == 0) {
                GCMUtil.asLongs((byte[])this.H, (long[])lArray[1]);
                GCMUtil.multiplyP7((long[])lArray[1], (long[])lArray[1]);
            } else {
                GCMUtil.multiplyP8((long[])this.T[i2 - 1][1], (long[])lArray[1]);
            }
            for (int i3 = 2; i3 < 256; i3 += 2) {
                GCMUtil.divideP((long[])lArray[i3 >> 1], (long[])lArray[i3]);
                GCMUtil.xor((long[])lArray[i3], (long[])lArray[1], (long[])lArray[i3 + 1]);
            }
        }
    }

    public void multiplyH(byte[] byArray) {
        long[] lArray = this.T[15][byArray[15] & 0xFF];
        long l2 = lArray[0];
        long l3 = lArray[1];
        for (int i2 = 14; i2 >= 0; --i2) {
            lArray = this.T[i2][byArray[i2] & 0xFF];
            l2 ^= lArray[0];
            l3 ^= lArray[1];
        }
        Pack.longToBigEndian((long)l2, (byte[])byArray, (int)0);
        Pack.longToBigEndian((long)l3, (byte[])byArray, (int)8);
    }
}

