/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes;

import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.BlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.BufferedBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.DataLengthException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.OutputLengthException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithIV;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Pack;

/*
 * Exception performing whole class analysis ignored.
 */
public class KXTSBlockCipher
extends BufferedBlockCipher {
    private static final long RED_POLY_128 = 135L;
    private static final long RED_POLY_256 = 1061L;
    private static final long RED_POLY_512 = 293L;
    private final int blockSize;
    private final long reductionPolynomial;
    private final long[] tw_init;
    private final long[] tw_current;
    private int counter;

    protected static long getReductionPolynomial(int n2) {
        switch (n2) {
            case 16: {
                return 135L;
            }
            case 32: {
                return 1061L;
            }
            case 64: {
                return 293L;
            }
        }
        throw new IllegalArgumentException("Only 128, 256, and 512 -bit block sizes supported");
    }

    public KXTSBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        this.reductionPolynomial = KXTSBlockCipher.getReductionPolynomial((int)this.blockSize);
        this.tw_init = new long[this.blockSize >>> 3];
        this.tw_current = new long[this.blockSize >>> 3];
        this.counter = -1;
    }

    public int getOutputSize(int n2) {
        return n2;
    }

    public int getUpdateOutputSize(int n2) {
        return n2;
    }

    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("Invalid parameters passed");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
        cipherParameters = parametersWithIV.getParameters();
        byte[] byArray = parametersWithIV.getIV();
        if (byArray.length != this.blockSize) {
            throw new IllegalArgumentException("Currently only support IVs of exactly one block");
        }
        byte[] byArray2 = new byte[this.blockSize];
        System.arraycopy(byArray, 0, byArray2, 0, this.blockSize);
        this.cipher.init(true, cipherParameters);
        this.cipher.processBlock(byArray2, 0, byArray2, 0);
        this.cipher.init(bl2, cipherParameters);
        Pack.littleEndianToLong((byte[])byArray2, (int)0, (long[])this.tw_init);
        System.arraycopy(this.tw_init, 0, this.tw_current, 0, this.tw_init.length);
        this.counter = 0;
    }

    public int processByte(byte by2, byte[] byArray, int n2) {
        throw new IllegalStateException("unsupported operation");
    }

    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (byArray.length - n2 < n3) {
            throw new DataLengthException("Input buffer too short");
        }
        if (byArray2.length - n2 < n3) {
            throw new OutputLengthException("Output buffer too short");
        }
        if (n3 % this.blockSize != 0) {
            throw new IllegalArgumentException("Partial blocks not supported");
        }
        for (int i2 = 0; i2 < n3; i2 += this.blockSize) {
            this.processBlock(byArray, n2 + i2, byArray2, n4 + i2);
        }
        return n3;
    }

    private void processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4;
        if (this.counter == -1) {
            throw new IllegalStateException("Attempt to process too many blocks");
        }
        ++this.counter;
        KXTSBlockCipher.GF_double((long)this.reductionPolynomial, (long[])this.tw_current);
        byte[] byArray3 = new byte[this.blockSize];
        Pack.longToLittleEndian((long[])this.tw_current, (byte[])byArray3, (int)0);
        byte[] byArray4 = new byte[this.blockSize];
        System.arraycopy(byArray3, 0, byArray4, 0, this.blockSize);
        for (n4 = 0; n4 < this.blockSize; ++n4) {
            int n5 = n4;
            byArray4[n5] = (byte)(byArray4[n5] ^ byArray[n2 + n4]);
        }
        this.cipher.processBlock(byArray4, 0, byArray4, 0);
        for (n4 = 0; n4 < this.blockSize; ++n4) {
            byArray2[n3 + n4] = (byte)(byArray4[n4] ^ byArray3[n4]);
        }
    }

    public int doFinal(byte[] byArray, int n2) {
        this.reset();
        return 0;
    }

    public void reset() {
        this.cipher.reset();
        System.arraycopy(this.tw_init, 0, this.tw_current, 0, this.tw_init.length);
        this.counter = 0;
    }

    private static void GF_double(long l2, long[] lArray) {
        long l3 = 0L;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            long l4 = lArray[i2];
            long l5 = l4 >>> 63;
            lArray[i2] = l4 << 1 ^ l3;
            l3 = l5;
        }
        lArray[0] = lArray[0] ^ l2 & -l3;
    }
}

