/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.macs;

import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Mac;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.digests.SkeinEngine;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.KeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.SkeinParameters;

public class SkeinMac
implements Mac {
    public static final int SKEIN_256 = 256;
    public static final int SKEIN_512 = 512;
    public static final int SKEIN_1024 = 1024;
    private SkeinEngine engine;

    public SkeinMac(int n2, int n3) {
        this.engine = new SkeinEngine(n2, n3);
    }

    public SkeinMac(SkeinMac skeinMac) {
        this.engine = new SkeinEngine(skeinMac.engine);
    }

    public String getAlgorithmName() {
        return "Skein-MAC-" + this.engine.getBlockSize() * 8 + "-" + this.engine.getOutputSize() * 8;
    }

    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        SkeinParameters skeinParameters;
        if (cipherParameters instanceof SkeinParameters) {
            skeinParameters = (SkeinParameters)cipherParameters;
        } else if (cipherParameters instanceof KeyParameter) {
            skeinParameters = new SkeinParameters.Builder().setKey(((KeyParameter)cipherParameters).getKey()).build();
        } else {
            throw new IllegalArgumentException("Invalid parameter passed to Skein MAC init - " + cipherParameters.getClass().getName());
        }
        if (skeinParameters.getKey() == null) {
            throw new IllegalArgumentException("Skein MAC requires a key parameter.");
        }
        this.engine.init(skeinParameters);
    }

    public int getMacSize() {
        return this.engine.getOutputSize();
    }

    public void reset() {
        this.engine.reset();
    }

    public void update(byte by2) {
        this.engine.update(by2);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.engine.update(byArray, n2, n3);
    }

    public int doFinal(byte[] byArray, int n2) {
        return this.engine.doFinal(byArray, n2);
    }
}

