/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.BufferedBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.InvalidCipherTextException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.StreamCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.io.CipherIOException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.io.InvalidCipherTextIOException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.AEADBlockCipher;

public class CipherOutputStream
extends FilterOutputStream {
    private BufferedBlockCipher bufferedBlockCipher;
    private StreamCipher streamCipher;
    private AEADBlockCipher aeadBlockCipher;
    private final byte[] oneByte = new byte[1];
    private byte[] buf;

    public CipherOutputStream(OutputStream outputStream, BufferedBlockCipher bufferedBlockCipher) {
        super(outputStream);
        this.bufferedBlockCipher = bufferedBlockCipher;
    }

    public CipherOutputStream(OutputStream outputStream, StreamCipher streamCipher) {
        super(outputStream);
        this.streamCipher = streamCipher;
    }

    public CipherOutputStream(OutputStream outputStream, AEADBlockCipher aEADBlockCipher) {
        super(outputStream);
        this.aeadBlockCipher = aEADBlockCipher;
    }

    @Override
    public void write(int n2) throws IOException {
        this.oneByte[0] = (byte)n2;
        if (this.streamCipher != null) {
            this.out.write(this.streamCipher.returnByte((byte)n2));
        } else {
            this.write(this.oneByte, 0, 1);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.ensureCapacity(n3, false);
        if (this.bufferedBlockCipher != null) {
            int n4 = this.bufferedBlockCipher.processBytes(byArray, n2, n3, this.buf, 0);
            if (n4 != 0) {
                this.out.write(this.buf, 0, n4);
            }
        } else if (this.aeadBlockCipher != null) {
            int n5 = this.aeadBlockCipher.processBytes(byArray, n2, n3, this.buf, 0);
            if (n5 != 0) {
                this.out.write(this.buf, 0, n5);
            }
        } else {
            this.streamCipher.processBytes(byArray, n2, n3, this.buf, 0);
            this.out.write(this.buf, 0, n3);
        }
    }

    private void ensureCapacity(int n2, boolean bl2) {
        int n3 = n2;
        if (bl2) {
            if (this.bufferedBlockCipher != null) {
                n3 = this.bufferedBlockCipher.getOutputSize(n2);
            } else if (this.aeadBlockCipher != null) {
                n3 = this.aeadBlockCipher.getOutputSize(n2);
            }
        } else if (this.bufferedBlockCipher != null) {
            n3 = this.bufferedBlockCipher.getUpdateOutputSize(n2);
        } else if (this.aeadBlockCipher != null) {
            n3 = this.aeadBlockCipher.getUpdateOutputSize(n2);
        }
        if (this.buf == null || this.buf.length < n3) {
            this.buf = new byte[n3];
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        Object object;
        block13: {
            this.ensureCapacity(0, true);
            object = null;
            try {
                int n2;
                if (this.bufferedBlockCipher != null) {
                    n2 = this.bufferedBlockCipher.doFinal(this.buf, 0);
                    if (n2 != 0) {
                        this.out.write(this.buf, 0, n2);
                    }
                } else if (this.aeadBlockCipher != null) {
                    n2 = this.aeadBlockCipher.doFinal(this.buf, 0);
                    if (n2 != 0) {
                        this.out.write(this.buf, 0, n2);
                    }
                } else if (this.streamCipher != null) {
                    this.streamCipher.reset();
                }
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                object = new InvalidCipherTextIOException("Error finalising cipher data", (Throwable)invalidCipherTextException);
            }
            catch (Exception exception) {
                object = new CipherIOException("Error closing stream: ", (Throwable)exception);
            }
            try {
                this.flush();
                this.out.close();
            }
            catch (IOException iOException) {
                if (object != null) break block13;
                object = iOException;
            }
        }
        if (object != null) {
            throw object;
        }
    }
}

