/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.engines;

import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.BlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.DataLengthException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.OutputLengthException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.engines.ThreefishEngine;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.KeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.TweakableBlockCipherParameters;

/*
 * Exception performing whole class analysis ignored.
 */
public class ThreefishEngine
implements BlockCipher {
    public static final int BLOCKSIZE_256 = 256;
    public static final int BLOCKSIZE_512 = 512;
    public static final int BLOCKSIZE_1024 = 1024;
    private static final int TWEAK_SIZE_BYTES = 16;
    private static final int TWEAK_SIZE_WORDS = 2;
    private static final int ROUNDS_256 = 72;
    private static final int ROUNDS_512 = 72;
    private static final int ROUNDS_1024 = 80;
    private static final int MAX_ROUNDS = 80;
    private static final long C_240 = 2004413935125273122L;
    private static int[] MOD9 = new int[80];
    private static int[] MOD17 = new int[MOD9.length];
    private static int[] MOD5 = new int[MOD9.length];
    private static int[] MOD3 = new int[MOD9.length];
    private int blocksizeBytes;
    private int blocksizeWords;
    private long[] currentBlock;
    private long[] t = new long[5];
    private long[] kw;
    private ThreefishCipher cipher;
    private boolean forEncryption;

    public ThreefishEngine(int n2) {
        this.blocksizeBytes = n2 / 8;
        this.blocksizeWords = this.blocksizeBytes / 8;
        this.currentBlock = new long[this.blocksizeWords];
        this.kw = new long[2 * this.blocksizeWords + 1];
        switch (n2) {
            case 256: {
                this.cipher = new Threefish256Cipher(this.kw, this.t);
                break;
            }
            case 512: {
                this.cipher = new Threefish512Cipher(this.kw, this.t);
                break;
            }
            case 1024: {
                this.cipher = new Threefish1024Cipher(this.kw, this.t);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid blocksize - Threefish is defined with block size of 256, 512, or 1024 bits");
            }
        }
    }

    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        byte[] byArray;
        byte[] byArray2;
        Object object;
        if (cipherParameters instanceof TweakableBlockCipherParameters) {
            object = (TweakableBlockCipherParameters)cipherParameters;
            byArray2 = object.getKey().getKey();
            byArray = object.getTweak();
        } else if (cipherParameters instanceof KeyParameter) {
            byArray2 = ((KeyParameter)cipherParameters).getKey();
            byArray = null;
        } else {
            throw new IllegalArgumentException("Invalid parameter passed to Threefish init - " + cipherParameters.getClass().getName());
        }
        object = null;
        long[] lArray = null;
        if (byArray2 != null) {
            if (byArray2.length != this.blocksizeBytes) {
                throw new IllegalArgumentException("Threefish key must be same size as block (" + this.blocksizeBytes + " bytes)");
            }
            object = new long[this.blocksizeWords];
            for (int i2 = 0; i2 < ((TweakableBlockCipherParameters)object).length; ++i2) {
                object[i2] = (TweakableBlockCipherParameters)ThreefishEngine.bytesToWord((byte[])byArray2, (int)(i2 * 8));
            }
        }
        if (byArray != null) {
            if (byArray.length != 16) {
                throw new IllegalArgumentException("Threefish tweak must be 16 bytes");
            }
            lArray = new long[]{ThreefishEngine.bytesToWord((byte[])byArray, (int)0), ThreefishEngine.bytesToWord((byte[])byArray, (int)8)};
        }
        this.init(bl2, (long[])object, lArray);
    }

    public void init(boolean bl2, long[] lArray, long[] lArray2) {
        this.forEncryption = bl2;
        if (lArray != null) {
            this.setKey(lArray);
        }
        if (lArray2 != null) {
            this.setTweak(lArray2);
        }
    }

    private void setKey(long[] lArray) {
        if (lArray.length != this.blocksizeWords) {
            throw new IllegalArgumentException("Threefish key must be same size as block (" + this.blocksizeWords + " words)");
        }
        long l2 = 2004413935125273122L;
        for (int i2 = 0; i2 < this.blocksizeWords; ++i2) {
            this.kw[i2] = lArray[i2];
            l2 ^= this.kw[i2];
        }
        this.kw[this.blocksizeWords] = l2;
        System.arraycopy(this.kw, 0, this.kw, this.blocksizeWords + 1, this.blocksizeWords);
    }

    private void setTweak(long[] lArray) {
        if (lArray.length != 2) {
            throw new IllegalArgumentException("Tweak must be 2 words.");
        }
        this.t[0] = lArray[0];
        this.t[1] = lArray[1];
        this.t[2] = this.t[0] ^ this.t[1];
        this.t[3] = this.t[0];
        this.t[4] = this.t[1];
    }

    public String getAlgorithmName() {
        return "Threefish-" + this.blocksizeBytes * 8;
    }

    public int getBlockSize() {
        return this.blocksizeBytes;
    }

    public void reset() {
    }

    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        int n4;
        if (n2 + this.blocksizeBytes > byArray.length) {
            throw new DataLengthException("Input buffer too short");
        }
        if (n3 + this.blocksizeBytes > byArray2.length) {
            throw new OutputLengthException("Output buffer too short");
        }
        for (n4 = 0; n4 < this.blocksizeBytes; n4 += 8) {
            this.currentBlock[n4 >> 3] = ThreefishEngine.bytesToWord((byte[])byArray, (int)(n2 + n4));
        }
        this.processBlock(this.currentBlock, this.currentBlock);
        for (n4 = 0; n4 < this.blocksizeBytes; n4 += 8) {
            ThreefishEngine.wordToBytes((long)this.currentBlock[n4 >> 3], (byte[])byArray2, (int)(n3 + n4));
        }
        return this.blocksizeBytes;
    }

    public int processBlock(long[] lArray, long[] lArray2) throws DataLengthException, IllegalStateException {
        if (this.kw[this.blocksizeWords] == 0L) {
            throw new IllegalStateException("Threefish engine not initialised");
        }
        if (lArray.length != this.blocksizeWords) {
            throw new DataLengthException("Input buffer too short");
        }
        if (lArray2.length != this.blocksizeWords) {
            throw new OutputLengthException("Output buffer too short");
        }
        if (this.forEncryption) {
            this.cipher.encryptBlock(lArray, lArray2);
        } else {
            this.cipher.decryptBlock(lArray, lArray2);
        }
        return this.blocksizeWords;
    }

    public static long bytesToWord(byte[] byArray, int n2) {
        if (n2 + 8 > byArray.length) {
            throw new IllegalArgumentException();
        }
        long l2 = 0L;
        int n3 = n2;
        l2 = (long)byArray[n3++] & 0xFFL;
        l2 |= ((long)byArray[n3++] & 0xFFL) << 8;
        l2 |= ((long)byArray[n3++] & 0xFFL) << 16;
        l2 |= ((long)byArray[n3++] & 0xFFL) << 24;
        l2 |= ((long)byArray[n3++] & 0xFFL) << 32;
        l2 |= ((long)byArray[n3++] & 0xFFL) << 40;
        l2 |= ((long)byArray[n3++] & 0xFFL) << 48;
        return l2 |= ((long)byArray[n3++] & 0xFFL) << 56;
    }

    public static void wordToBytes(long l2, byte[] byArray, int n2) {
        if (n2 + 8 > byArray.length) {
            throw new IllegalArgumentException();
        }
        int n3 = n2;
        byArray[n3++] = (byte)l2;
        byArray[n3++] = (byte)(l2 >> 8);
        byArray[n3++] = (byte)(l2 >> 16);
        byArray[n3++] = (byte)(l2 >> 24);
        byArray[n3++] = (byte)(l2 >> 32);
        byArray[n3++] = (byte)(l2 >> 40);
        byArray[n3++] = (byte)(l2 >> 48);
        byArray[n3++] = (byte)(l2 >> 56);
    }

    static long rotlXor(long l2, int n2, long l3) {
        return (l2 << n2 | l2 >>> -n2) ^ l3;
    }

    static long xorRotr(long l2, int n2, long l3) {
        long l4 = l2 ^ l3;
        return l4 >>> n2 | l4 << -n2;
    }

    static /* synthetic */ int[] access$000() {
        return MOD5;
    }

    static /* synthetic */ int[] access$100() {
        return MOD3;
    }

    static /* synthetic */ int[] access$200() {
        return MOD9;
    }

    static /* synthetic */ int[] access$300() {
        return MOD17;
    }

    static {
        for (int i2 = 0; i2 < MOD9.length; ++i2) {
            ThreefishEngine.MOD17[i2] = i2 % 17;
            ThreefishEngine.MOD9[i2] = i2 % 9;
            ThreefishEngine.MOD5[i2] = i2 % 5;
            ThreefishEngine.MOD3[i2] = i2 % 3;
        }
    }
}

