/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.digests;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.OutputLengthException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.digests.SkeinEngine;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.engines.ThreefishEngine;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.SkeinParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Memoable;

/*
 * Exception performing whole class analysis ignored.
 */
public class SkeinEngine
implements Memoable {
    public static final int SKEIN_256 = 256;
    public static final int SKEIN_512 = 512;
    public static final int SKEIN_1024 = 1024;
    private static final int PARAM_TYPE_KEY = 0;
    private static final int PARAM_TYPE_CONFIG = 4;
    private static final int PARAM_TYPE_MESSAGE = 48;
    private static final int PARAM_TYPE_OUTPUT = 63;
    private static final Hashtable INITIAL_STATES = new Hashtable();
    final ThreefishEngine threefish;
    private final int outputSizeBytes;
    long[] chain;
    private long[] initialState;
    private byte[] key;
    private Parameter[] preMessageParameters;
    private Parameter[] postMessageParameters;
    private final UBI ubi;
    private final byte[] singleByte = new byte[1];

    private static void initialState(int n2, int n3, long[] lArray) {
        INITIAL_STATES.put(SkeinEngine.variantIdentifier((int)(n2 / 8), (int)(n3 / 8)), lArray);
    }

    private static Integer variantIdentifier(int n2, int n3) {
        return new Integer(n3 << 16 | n2);
    }

    public SkeinEngine(int n2, int n3) {
        if (n3 % 8 != 0) {
            throw new IllegalArgumentException("Output size must be a multiple of 8 bits. :" + n3);
        }
        this.outputSizeBytes = n3 / 8;
        this.threefish = new ThreefishEngine(n2);
        this.ubi = new UBI(this, this.threefish.getBlockSize());
    }

    public SkeinEngine(SkeinEngine skeinEngine) {
        this(skeinEngine.getBlockSize() * 8, skeinEngine.getOutputSize() * 8);
        this.copyIn(skeinEngine);
    }

    private void copyIn(SkeinEngine skeinEngine) {
        this.ubi.reset(skeinEngine.ubi);
        this.chain = Arrays.clone((long[])skeinEngine.chain, (long[])this.chain);
        this.initialState = Arrays.clone((long[])skeinEngine.initialState, (long[])this.initialState);
        this.key = Arrays.clone((byte[])skeinEngine.key, (byte[])this.key);
        this.preMessageParameters = SkeinEngine.clone((Parameter[])skeinEngine.preMessageParameters, (Parameter[])this.preMessageParameters);
        this.postMessageParameters = SkeinEngine.clone((Parameter[])skeinEngine.postMessageParameters, (Parameter[])this.postMessageParameters);
    }

    private static Parameter[] clone(Parameter[] parameterArray, Parameter[] parameterArray2) {
        if (parameterArray == null) {
            return null;
        }
        if (parameterArray2 == null || parameterArray2.length != parameterArray.length) {
            parameterArray2 = new Parameter[parameterArray.length];
        }
        System.arraycopy(parameterArray, 0, parameterArray2, 0, parameterArray2.length);
        return parameterArray2;
    }

    public Memoable copy() {
        return new SkeinEngine(this);
    }

    public void reset(Memoable memoable) {
        SkeinEngine skeinEngine = (SkeinEngine)memoable;
        if (this.getBlockSize() != skeinEngine.getBlockSize() || this.outputSizeBytes != skeinEngine.outputSizeBytes) {
            throw new IllegalArgumentException("Incompatible parameters in provided SkeinEngine.");
        }
        this.copyIn(skeinEngine);
    }

    public int getOutputSize() {
        return this.outputSizeBytes;
    }

    public int getBlockSize() {
        return this.threefish.getBlockSize();
    }

    public void init(SkeinParameters skeinParameters) {
        this.chain = null;
        this.key = null;
        this.preMessageParameters = null;
        this.postMessageParameters = null;
        if (skeinParameters != null) {
            byte[] byArray = skeinParameters.getKey();
            if (byArray.length < 16) {
                throw new IllegalArgumentException("Skein key must be at least 128 bits.");
            }
            this.initParams(skeinParameters.getParameters());
        }
        this.createInitialState();
        this.ubiInit(48);
    }

    private void initParams(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        Vector<Parameter> vector = new Vector<Parameter>();
        Vector<Parameter> vector2 = new Vector<Parameter>();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            byte[] byArray = (byte[])hashtable.get(n2);
            if (n2 == 0) {
                this.key = byArray;
                continue;
            }
            if (n2 < 48) {
                vector.addElement(new Parameter(n2.intValue(), byArray));
                continue;
            }
            vector2.addElement(new Parameter(n2.intValue(), byArray));
        }
        this.preMessageParameters = new Parameter[vector.size()];
        vector.copyInto(this.preMessageParameters);
        SkeinEngine.sort((Parameter[])this.preMessageParameters);
        this.postMessageParameters = new Parameter[vector2.size()];
        vector2.copyInto(this.postMessageParameters);
        SkeinEngine.sort((Parameter[])this.postMessageParameters);
    }

    private static void sort(Parameter[] parameterArray) {
        if (parameterArray == null) {
            return;
        }
        for (int i2 = 1; i2 < parameterArray.length; ++i2) {
            Parameter parameter = parameterArray[i2];
            for (int i3 = i2; i3 > 0 && parameter.getType() < parameterArray[i3 - 1].getType(); --i3) {
                parameterArray[i3] = parameterArray[i3 - 1];
            }
            parameterArray[i3] = parameter;
        }
    }

    private void createInitialState() {
        long[] lArray = (long[])INITIAL_STATES.get(SkeinEngine.variantIdentifier((int)this.getBlockSize(), (int)this.getOutputSize()));
        if (this.key == null && lArray != null) {
            this.chain = Arrays.clone((long[])lArray);
        } else {
            this.chain = new long[this.getBlockSize() / 8];
            if (this.key != null) {
                this.ubiComplete(0, this.key);
            }
            this.ubiComplete(4, new Configuration((long)(this.outputSizeBytes * 8)).getBytes());
        }
        if (this.preMessageParameters != null) {
            for (int i2 = 0; i2 < this.preMessageParameters.length; ++i2) {
                Parameter parameter = this.preMessageParameters[i2];
                this.ubiComplete(parameter.getType(), parameter.getValue());
            }
        }
        this.initialState = Arrays.clone((long[])this.chain);
    }

    public void reset() {
        System.arraycopy(this.initialState, 0, this.chain, 0, this.chain.length);
        this.ubiInit(48);
    }

    private void ubiComplete(int n2, byte[] byArray) {
        this.ubiInit(n2);
        this.ubi.update(byArray, 0, byArray.length, this.chain);
        this.ubiFinal();
    }

    private void ubiInit(int n2) {
        this.ubi.reset(n2);
    }

    private void ubiFinal() {
        this.ubi.doFinal(this.chain);
    }

    private void checkInitialised() {
        if (this.ubi == null) {
            throw new IllegalArgumentException("Skein engine is not initialised.");
        }
    }

    public void update(byte by2) {
        this.singleByte[0] = by2;
        this.update(this.singleByte, 0, 1);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.checkInitialised();
        this.ubi.update(byArray, n2, n3, this.chain);
    }

    public int doFinal(byte[] byArray, int n2) {
        int n3;
        this.checkInitialised();
        if (byArray.length < n2 + this.outputSizeBytes) {
            throw new OutputLengthException("Output buffer is too short to hold output");
        }
        this.ubiFinal();
        if (this.postMessageParameters != null) {
            for (n3 = 0; n3 < this.postMessageParameters.length; ++n3) {
                Parameter parameter = this.postMessageParameters[n3];
                this.ubiComplete(parameter.getType(), parameter.getValue());
            }
        }
        n3 = this.getBlockSize();
        int n4 = (this.outputSizeBytes + n3 - 1) / n3;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = Math.min(n3, this.outputSizeBytes - i2 * n3);
            this.output((long)i2, byArray, n2 + i2 * n3, n5);
        }
        this.reset();
        return this.outputSizeBytes;
    }

    private void output(long l2, byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[8];
        ThreefishEngine.wordToBytes((long)l2, (byte[])byArray2, (int)0);
        long[] lArray = new long[this.chain.length];
        this.ubiInit(63);
        this.ubi.update(byArray2, 0, byArray2.length, lArray);
        this.ubi.doFinal(lArray);
        int n4 = (n3 + 8 - 1) / 8;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = Math.min(8, n3 - i2 * 8);
            if (n5 == 8) {
                ThreefishEngine.wordToBytes((long)lArray[i2], (byte[])byArray, (int)(n2 + i2 * 8));
                continue;
            }
            ThreefishEngine.wordToBytes((long)lArray[i2], (byte[])byArray2, (int)0);
            System.arraycopy(byArray2, 0, byArray, n2 + i2 * 8, n5);
        }
    }

    static {
        SkeinEngine.initialState((int)256, (int)128, (long[])new long[]{-2228972824489528736L, -8629553674646093540L, 1155188648486244218L, -3677226592081559102L});
        SkeinEngine.initialState((int)256, (int)160, (long[])new long[]{1450197650740764312L, 3081844928540042640L, -3136097061834271170L, 3301952811952417661L});
        SkeinEngine.initialState((int)256, (int)224, (long[])new long[]{-4176654842910610933L, -8688192972455077604L, -7364642305011795836L, 4056579644589979102L});
        SkeinEngine.initialState((int)256, (int)256, (long[])new long[]{-243853671043386295L, 3443677322885453875L, -5531612722399640561L, 7662005193972177513L});
        SkeinEngine.initialState((int)512, (int)128, (long[])new long[]{-6288014694233956526L, 2204638249859346602L, 3502419045458743507L, -4829063503441264548L, 983504137758028059L, 1880512238245786339L, -6715892782214108542L, 7602827311880509485L});
        SkeinEngine.initialState((int)512, (int)160, (long[])new long[]{2934123928682216849L, -4399710721982728305L, 1684584802963255058L, 5744138295201861711L, 2444857010922934358L, -2807833639722848072L, -5121587834665610502L, 118355523173251694L});
        SkeinEngine.initialState((int)512, (int)224, (long[])new long[]{-3688341020067007964L, -3772225436291745297L, -8300862168937575580L, 4146387520469897396L, 1106145742801415120L, 7455425944880474941L, -7351063101234211863L, -7048981346965512457L});
        SkeinEngine.initialState((int)512, (int)384, (long[])new long[]{-6631894876634615969L, -5692838220127733084L, -7099962856338682626L, -2911352911530754598L, 2000907093792408677L, 9140007292425499655L, 6093301768906360022L, 2769176472213098488L});
        SkeinEngine.initialState((int)512, (int)512, (long[])new long[]{5261240102383538638L, 978932832955457283L, -8083517948103779378L, -7339365279355032399L, 6752626034097301424L, -1531723821829733388L, -7417126464950782685L, -5901786942805128141L});
    }
}

