/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.digests;

import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.ExtendedDigest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.digests.SkeinEngine;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.SkeinParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Memoable;

public class SkeinDigest
implements ExtendedDigest,
Memoable {
    public static final int SKEIN_256 = 256;
    public static final int SKEIN_512 = 512;
    public static final int SKEIN_1024 = 1024;
    private SkeinEngine engine;

    public SkeinDigest(int n2, int n3) {
        this.engine = new SkeinEngine(n2, n3);
        this.init(null);
    }

    public SkeinDigest(SkeinDigest skeinDigest) {
        this.engine = new SkeinEngine(skeinDigest.engine);
    }

    public void reset(Memoable memoable) {
        SkeinDigest skeinDigest = (SkeinDigest)memoable;
        this.engine.reset((Memoable)skeinDigest.engine);
    }

    public Memoable copy() {
        return new SkeinDigest(this);
    }

    public String getAlgorithmName() {
        return "Skein-" + this.engine.getBlockSize() * 8 + "-" + this.engine.getOutputSize() * 8;
    }

    public int getDigestSize() {
        return this.engine.getOutputSize();
    }

    public int getByteLength() {
        return this.engine.getBlockSize();
    }

    public void init(SkeinParameters skeinParameters) {
        this.engine.init(skeinParameters);
    }

    public void reset() {
        this.engine.reset();
    }

    public void update(byte by2) {
        this.engine.update(by2);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.engine.update(byArray, n2, n3);
    }

    public int doFinal(byte[] byArray, int n2) {
        return this.engine.doFinal(byArray, n2);
    }
}

