/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.agreement;

import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.BasicAgreement;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECDomainParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.MQVPrivateParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.MQVPublicParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECAlgorithms;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECConstants;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECCurve;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Properties;

public class ECMQVBasicAgreement
implements BasicAgreement {
    MQVPrivateParameters privParams;

    public void init(CipherParameters cipherParameters) {
        this.privParams = (MQVPrivateParameters)cipherParameters;
    }

    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        if (Properties.isOverrideSet((String)"macromedia.externals.org.bouncycastle_1_60_0_0.ec.disable_mqv")) {
            throw new IllegalStateException("ECMQV explicitly disabled");
        }
        MQVPublicParameters mQVPublicParameters = (MQVPublicParameters)cipherParameters;
        ECPrivateKeyParameters eCPrivateKeyParameters = this.privParams.getStaticPrivateKey();
        ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
        if (!eCDomainParameters.equals((Object)mQVPublicParameters.getStaticPublicKey().getParameters())) {
            throw new IllegalStateException("ECMQV public key components have wrong domain parameters");
        }
        ECPoint eCPoint = this.calculateMqvAgreement(eCDomainParameters, eCPrivateKeyParameters, this.privParams.getEphemeralPrivateKey(), this.privParams.getEphemeralPublicKey(), mQVPublicParameters.getStaticPublicKey(), mQVPublicParameters.getEphemeralPublicKey()).normalize();
        if (eCPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for MQV");
        }
        return eCPoint.getAffineXCoord().toBigInteger();
    }

    private ECPoint calculateMqvAgreement(ECDomainParameters eCDomainParameters, ECPrivateKeyParameters eCPrivateKeyParameters, ECPrivateKeyParameters eCPrivateKeyParameters2, ECPublicKeyParameters eCPublicKeyParameters, ECPublicKeyParameters eCPublicKeyParameters2, ECPublicKeyParameters eCPublicKeyParameters3) {
        BigInteger bigInteger = eCDomainParameters.getN();
        int n2 = (bigInteger.bitLength() + 1) / 2;
        BigInteger bigInteger2 = ECConstants.ONE.shiftLeft(n2);
        ECCurve eCCurve = eCDomainParameters.getCurve();
        ECPoint eCPoint = ECAlgorithms.cleanPoint((ECCurve)eCCurve, (ECPoint)eCPublicKeyParameters.getQ());
        ECPoint eCPoint2 = ECAlgorithms.cleanPoint((ECCurve)eCCurve, (ECPoint)eCPublicKeyParameters2.getQ());
        ECPoint eCPoint3 = ECAlgorithms.cleanPoint((ECCurve)eCCurve, (ECPoint)eCPublicKeyParameters3.getQ());
        BigInteger bigInteger3 = eCPoint.getAffineXCoord().toBigInteger();
        BigInteger bigInteger4 = bigInteger3.mod(bigInteger2);
        BigInteger bigInteger5 = bigInteger4.setBit(n2);
        BigInteger bigInteger6 = eCPrivateKeyParameters.getD().multiply(bigInteger5).add(eCPrivateKeyParameters2.getD()).mod(bigInteger);
        BigInteger bigInteger7 = eCPoint3.getAffineXCoord().toBigInteger();
        BigInteger bigInteger8 = bigInteger7.mod(bigInteger2);
        BigInteger bigInteger9 = bigInteger8.setBit(n2);
        BigInteger bigInteger10 = eCDomainParameters.getH().multiply(bigInteger6).mod(bigInteger);
        return ECAlgorithms.sumOfTwoMultiplies((ECPoint)eCPoint2, (BigInteger)bigInteger9.multiply(bigInteger10).mod(bigInteger), (ECPoint)eCPoint3, (BigInteger)bigInteger10);
    }
}

