/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.qualified;

import java.math.BigInteger;
import java.util.Enumeration;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.qualified.Iso4217CurrencyCode;

public class MonetaryValue
extends ASN1Object {
    private Iso4217CurrencyCode currency;
    private ASN1Integer amount;
    private ASN1Integer exponent;

    public static MonetaryValue getInstance(Object object) {
        if (object instanceof MonetaryValue) {
            return (MonetaryValue)object;
        }
        if (object != null) {
            return new MonetaryValue(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    private MonetaryValue(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.currency = Iso4217CurrencyCode.getInstance(enumeration.nextElement());
        this.amount = ASN1Integer.getInstance(enumeration.nextElement());
        this.exponent = ASN1Integer.getInstance(enumeration.nextElement());
    }

    public MonetaryValue(Iso4217CurrencyCode iso4217CurrencyCode, int n2, int n3) {
        this.currency = iso4217CurrencyCode;
        this.amount = new ASN1Integer((long)n2);
        this.exponent = new ASN1Integer((long)n3);
    }

    public Iso4217CurrencyCode getCurrency() {
        return this.currency;
    }

    public BigInteger getAmount() {
        return this.amount.getValue();
    }

    public BigInteger getExponent() {
        return this.exponent.getValue();
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.currency);
        aSN1EncodableVector.add((ASN1Encodable)this.amount);
        aSN1EncodableVector.add((ASN1Encodable)this.exponent);
        return new DERSequence(aSN1EncodableVector);
    }
}

