/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ua;

import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1OctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1TaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DEROctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERTaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ua.DSTU4145BinaryField;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ua.DSTU4145PointEncoder;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECDomainParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECAlgorithms;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECCurve;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.field.PolynomialExtensionField;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class DSTU4145ECBinary
extends ASN1Object {
    BigInteger version = BigInteger.valueOf(0L);
    DSTU4145BinaryField f;
    ASN1Integer a;
    ASN1OctetString b;
    ASN1Integer n;
    ASN1OctetString bp;

    public DSTU4145ECBinary(ECDomainParameters eCDomainParameters) {
        ECCurve eCCurve = eCDomainParameters.getCurve();
        if (!ECAlgorithms.isF2mCurve((ECCurve)eCCurve)) {
            throw new IllegalArgumentException("only binary domain is possible");
        }
        PolynomialExtensionField polynomialExtensionField = (PolynomialExtensionField)eCCurve.getField();
        int[] nArray = polynomialExtensionField.getMinimalPolynomial().getExponentsPresent();
        if (nArray.length == 3) {
            this.f = new DSTU4145BinaryField(nArray[2], nArray[1]);
        } else if (nArray.length == 5) {
            this.f = new DSTU4145BinaryField(nArray[4], nArray[1], nArray[2], nArray[3]);
        } else {
            throw new IllegalArgumentException("curve must have a trinomial or pentanomial basis");
        }
        this.a = new ASN1Integer(eCCurve.getA().toBigInteger());
        this.b = new DEROctetString(eCCurve.getB().getEncoded());
        this.n = new ASN1Integer(eCDomainParameters.getN());
        this.bp = new DEROctetString(DSTU4145PointEncoder.encodePoint((ECPoint)eCDomainParameters.getG()));
    }

    private DSTU4145ECBinary(ASN1Sequence aSN1Sequence) {
        int n2 = 0;
        if (aSN1Sequence.getObjectAt(n2) instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(n2);
            if (aSN1TaggedObject.isExplicit() && 0 == aSN1TaggedObject.getTagNo()) {
                this.version = ASN1Integer.getInstance((Object)aSN1TaggedObject.getLoadedObject()).getValue();
                ++n2;
            } else {
                throw new IllegalArgumentException("object parse error");
            }
        }
        this.f = DSTU4145BinaryField.getInstance((Object)aSN1Sequence.getObjectAt(n2));
        this.a = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(++n2));
        this.b = ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(++n2));
        this.n = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(++n2));
        this.bp = ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(++n2));
    }

    public static DSTU4145ECBinary getInstance(Object object) {
        if (object instanceof DSTU4145ECBinary) {
            return (DSTU4145ECBinary)object;
        }
        if (object != null) {
            return new DSTU4145ECBinary(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public DSTU4145BinaryField getField() {
        return this.f;
    }

    public BigInteger getA() {
        return this.a.getValue();
    }

    public byte[] getB() {
        return Arrays.clone((byte[])this.b.getOctets());
    }

    public BigInteger getN() {
        return this.n.getValue();
    }

    public byte[] getG() {
        return Arrays.clone((byte[])this.bp.getOctets());
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (0 != this.version.compareTo(BigInteger.valueOf(0L))) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new ASN1Integer(this.version)));
        }
        aSN1EncodableVector.add((ASN1Encodable)this.f);
        aSN1EncodableVector.add((ASN1Encodable)this.a);
        aSN1EncodableVector.add((ASN1Encodable)this.b);
        aSN1EncodableVector.add((ASN1Encodable)this.n);
        aSN1EncodableVector.add((ASN1Encodable)this.bp);
        return new DERSequence(aSN1EncodableVector);
    }
}

