/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.misc;

import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1OctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DEROctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class ScryptParams
extends ASN1Object {
    private final byte[] salt;
    private final BigInteger costParameter;
    private final BigInteger blockSize;
    private final BigInteger parallelizationParameter;
    private final BigInteger keyLength;

    public ScryptParams(byte[] byArray, int n2, int n3, int n4) {
        this(byArray, BigInteger.valueOf(n2), BigInteger.valueOf(n3), BigInteger.valueOf(n4), null);
    }

    public ScryptParams(byte[] byArray, int n2, int n3, int n4, int n5) {
        this(byArray, BigInteger.valueOf(n2), BigInteger.valueOf(n3), BigInteger.valueOf(n4), BigInteger.valueOf(n5));
    }

    public ScryptParams(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this.salt = Arrays.clone((byte[])byArray);
        this.costParameter = bigInteger;
        this.blockSize = bigInteger2;
        this.parallelizationParameter = bigInteger3;
        this.keyLength = bigInteger4;
    }

    public static ScryptParams getInstance(Object object) {
        if (object instanceof ScryptParams) {
            return (ScryptParams)object;
        }
        if (object != null) {
            return new ScryptParams(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    private ScryptParams(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 4 && aSN1Sequence.size() != 5) {
            throw new IllegalArgumentException("invalid sequence: size = " + aSN1Sequence.size());
        }
        this.salt = Arrays.clone((byte[])ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(0)).getOctets());
        this.costParameter = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(1)).getValue();
        this.blockSize = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(2)).getValue();
        this.parallelizationParameter = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(3)).getValue();
        this.keyLength = aSN1Sequence.size() == 5 ? ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(4)).getValue() : null;
    }

    public byte[] getSalt() {
        return Arrays.clone((byte[])this.salt);
    }

    public BigInteger getCostParameter() {
        return this.costParameter;
    }

    public BigInteger getBlockSize() {
        return this.blockSize;
    }

    public BigInteger getParallelizationParameter() {
        return this.parallelizationParameter;
    }

    public BigInteger getKeyLength() {
        return this.keyLength;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)new DEROctetString(this.salt));
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(this.costParameter));
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(this.blockSize));
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(this.parallelizationParameter));
        if (this.keyLength != null) {
            aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(this.keyLength));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

