/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.icao;

import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERPrintableString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;

public class LDSVersionInfo
extends ASN1Object {
    private DERPrintableString ldsVersion;
    private DERPrintableString unicodeVersion;

    public LDSVersionInfo(String string, String string2) {
        this.ldsVersion = new DERPrintableString(string);
        this.unicodeVersion = new DERPrintableString(string2);
    }

    private LDSVersionInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("sequence wrong size for LDSVersionInfo");
        }
        this.ldsVersion = DERPrintableString.getInstance((Object)aSN1Sequence.getObjectAt(0));
        this.unicodeVersion = DERPrintableString.getInstance((Object)aSN1Sequence.getObjectAt(1));
    }

    public static LDSVersionInfo getInstance(Object object) {
        if (object instanceof LDSVersionInfo) {
            return (LDSVersionInfo)object;
        }
        if (object != null) {
            return new LDSVersionInfo(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public String getLdsVersion() {
        return this.ldsVersion.getString();
    }

    public String getUnicodeVersion() {
        return this.unicodeVersion.getString();
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.ldsVersion);
        aSN1EncodableVector.add((ASN1Encodable)this.unicodeVersion);
        return new DERSequence(aSN1EncodableVector);
    }
}

