/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.esf;

import java.util.Enumeration;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1TaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERTaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.esf.OtherRevVals;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ocsp.BasicOCSPResponse;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.CertificateList;

public class RevocationValues
extends ASN1Object {
    private ASN1Sequence crlVals;
    private ASN1Sequence ocspVals;
    private OtherRevVals otherRevVals;

    public static RevocationValues getInstance(Object object) {
        if (object instanceof RevocationValues) {
            return (RevocationValues)object;
        }
        if (object != null) {
            return new RevocationValues(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    private RevocationValues(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() > 3) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        block5: while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1TaggedObject.getObject();
                    Enumeration enumeration2 = aSN1Sequence2.getObjects();
                    while (enumeration2.hasMoreElements()) {
                        CertificateList.getInstance(enumeration2.nextElement());
                    }
                    this.crlVals = aSN1Sequence2;
                    continue block5;
                }
                case 1: {
                    ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1TaggedObject.getObject();
                    Enumeration enumeration3 = aSN1Sequence3.getObjects();
                    while (enumeration3.hasMoreElements()) {
                        BasicOCSPResponse.getInstance(enumeration3.nextElement());
                    }
                    this.ocspVals = aSN1Sequence3;
                    continue block5;
                }
                case 2: {
                    this.otherRevVals = OtherRevVals.getInstance((Object)aSN1TaggedObject.getObject());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("invalid tag: " + aSN1TaggedObject.getTagNo());
        }
    }

    public RevocationValues(CertificateList[] certificateListArray, BasicOCSPResponse[] basicOCSPResponseArray, OtherRevVals otherRevVals) {
        if (null != certificateListArray) {
            this.crlVals = new DERSequence((ASN1Encodable[])certificateListArray);
        }
        if (null != basicOCSPResponseArray) {
            this.ocspVals = new DERSequence((ASN1Encodable[])basicOCSPResponseArray);
        }
        this.otherRevVals = otherRevVals;
    }

    public CertificateList[] getCrlVals() {
        if (null == this.crlVals) {
            return new CertificateList[0];
        }
        CertificateList[] certificateListArray = new CertificateList[this.crlVals.size()];
        for (int i2 = 0; i2 < certificateListArray.length; ++i2) {
            certificateListArray[i2] = CertificateList.getInstance((Object)this.crlVals.getObjectAt(i2));
        }
        return certificateListArray;
    }

    public BasicOCSPResponse[] getOcspVals() {
        if (null == this.ocspVals) {
            return new BasicOCSPResponse[0];
        }
        BasicOCSPResponse[] basicOCSPResponseArray = new BasicOCSPResponse[this.ocspVals.size()];
        for (int i2 = 0; i2 < basicOCSPResponseArray.length; ++i2) {
            basicOCSPResponseArray[i2] = BasicOCSPResponse.getInstance((Object)this.ocspVals.getObjectAt(i2));
        }
        return basicOCSPResponseArray;
    }

    public OtherRevVals getOtherRevVals() {
        return this.otherRevVals;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (null != this.crlVals) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)this.crlVals));
        }
        if (null != this.ocspVals) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)this.ocspVals));
        }
        if (null != this.otherRevVals) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(true, 2, (ASN1Encodable)this.otherRevVals.toASN1Primitive()));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

