/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.crmf;

import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Choice;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1TaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERNull;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERTaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.crmf.POPOPrivKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.crmf.POPOSigningKey;

public class ProofOfPossession
extends ASN1Object
implements ASN1Choice {
    public static final int TYPE_RA_VERIFIED = 0;
    public static final int TYPE_SIGNING_KEY = 1;
    public static final int TYPE_KEY_ENCIPHERMENT = 2;
    public static final int TYPE_KEY_AGREEMENT = 3;
    private int tagNo;
    private ASN1Encodable obj;

    private ProofOfPossession(ASN1TaggedObject aSN1TaggedObject) {
        this.tagNo = aSN1TaggedObject.getTagNo();
        switch (this.tagNo) {
            case 0: {
                this.obj = DERNull.INSTANCE;
                break;
            }
            case 1: {
                this.obj = POPOSigningKey.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)false);
                break;
            }
            case 2: 
            case 3: {
                this.obj = POPOPrivKey.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)true);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag: " + this.tagNo);
            }
        }
    }

    public static ProofOfPossession getInstance(Object object) {
        if (object == null || object instanceof ProofOfPossession) {
            return (ProofOfPossession)object;
        }
        if (object instanceof ASN1TaggedObject) {
            return new ProofOfPossession((ASN1TaggedObject)object);
        }
        throw new IllegalArgumentException("Invalid object: " + object.getClass().getName());
    }

    public ProofOfPossession() {
        this.tagNo = 0;
        this.obj = DERNull.INSTANCE;
    }

    public ProofOfPossession(POPOSigningKey pOPOSigningKey) {
        this.tagNo = 1;
        this.obj = pOPOSigningKey;
    }

    public ProofOfPossession(int n2, POPOPrivKey pOPOPrivKey) {
        this.tagNo = n2;
        this.obj = pOPOPrivKey;
    }

    public int getType() {
        return this.tagNo;
    }

    public ASN1Encodable getObject() {
        return this.obj;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(false, this.tagNo, this.obj);
    }
}

