/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.crmf;

import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1OctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DEROctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cms.IssuerAndSerialNumber;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class DhSigStatic
extends ASN1Object {
    private final IssuerAndSerialNumber issuerAndSerial;
    private final ASN1OctetString hashValue;

    public DhSigStatic(byte[] byArray) {
        this(null, byArray);
    }

    public DhSigStatic(IssuerAndSerialNumber issuerAndSerialNumber, byte[] byArray) {
        this.issuerAndSerial = issuerAndSerialNumber;
        this.hashValue = new DEROctetString(Arrays.clone((byte[])byArray));
    }

    public static DhSigStatic getInstance(Object object) {
        if (object instanceof DhSigStatic) {
            return (DhSigStatic)object;
        }
        if (object != null) {
            return new DhSigStatic(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    private DhSigStatic(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 1) {
            this.issuerAndSerial = null;
            this.hashValue = ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(0));
        } else if (aSN1Sequence.size() == 2) {
            this.issuerAndSerial = IssuerAndSerialNumber.getInstance((Object)aSN1Sequence.getObjectAt(0));
            this.hashValue = ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(1));
        } else {
            throw new IllegalArgumentException("sequence wrong length for DhSigStatic");
        }
    }

    public IssuerAndSerialNumber getIssuerAndSerial() {
        return this.issuerAndSerial;
    }

    public byte[] getHashValue() {
        return Arrays.clone((byte[])this.hashValue.getOctets());
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.issuerAndSerial != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.issuerAndSerial);
        }
        aSN1EncodableVector.add((ASN1Encodable)this.hashValue);
        return new DERSequence(aSN1EncodableVector);
    }
}

