/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cms;

import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1OctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.BERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERIA5String;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cms.Evidence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cms.MetaData;

public class TimeStampedData
extends ASN1Object {
    private ASN1Integer version;
    private DERIA5String dataUri;
    private MetaData metaData;
    private ASN1OctetString content;
    private Evidence temporalEvidence;

    public TimeStampedData(DERIA5String dERIA5String, MetaData metaData, ASN1OctetString aSN1OctetString, Evidence evidence) {
        this.version = new ASN1Integer(1L);
        this.dataUri = dERIA5String;
        this.metaData = metaData;
        this.content = aSN1OctetString;
        this.temporalEvidence = evidence;
    }

    private TimeStampedData(ASN1Sequence aSN1Sequence) {
        this.version = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(0));
        int n2 = 1;
        if (aSN1Sequence.getObjectAt(n2) instanceof DERIA5String) {
            this.dataUri = DERIA5String.getInstance((Object)aSN1Sequence.getObjectAt(n2++));
        }
        if (aSN1Sequence.getObjectAt(n2) instanceof MetaData || aSN1Sequence.getObjectAt(n2) instanceof ASN1Sequence) {
            this.metaData = MetaData.getInstance((Object)aSN1Sequence.getObjectAt(n2++));
        }
        if (aSN1Sequence.getObjectAt(n2) instanceof ASN1OctetString) {
            this.content = ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(n2++));
        }
        this.temporalEvidence = Evidence.getInstance((Object)aSN1Sequence.getObjectAt(n2));
    }

    public static TimeStampedData getInstance(Object object) {
        if (object == null || object instanceof TimeStampedData) {
            return (TimeStampedData)object;
        }
        return new TimeStampedData(ASN1Sequence.getInstance((Object)object));
    }

    public DERIA5String getDataUri() {
        return this.dataUri;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public ASN1OctetString getContent() {
        return this.content;
    }

    public Evidence getTemporalEvidence() {
        return this.temporalEvidence;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.version);
        if (this.dataUri != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.dataUri);
        }
        if (this.metaData != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.metaData);
        }
        if (this.content != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.content);
        }
        aSN1EncodableVector.add((ASN1Encodable)this.temporalEvidence);
        return new BERSequence(aSN1EncodableVector);
    }
}

