/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmp;

import java.util.Enumeration;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1TaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERTaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmp.PKIStatusInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.crmf.CertId;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.CertificateList;

public class RevRepContent
extends ASN1Object {
    private ASN1Sequence status;
    private ASN1Sequence revCerts;
    private ASN1Sequence crls;

    private RevRepContent(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.status = ASN1Sequence.getInstance(enumeration.nextElement());
        while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(enumeration.nextElement());
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.revCerts = ASN1Sequence.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)true);
                continue;
            }
            this.crls = ASN1Sequence.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)true);
        }
    }

    public static RevRepContent getInstance(Object object) {
        if (object instanceof RevRepContent) {
            return (RevRepContent)object;
        }
        if (object != null) {
            return new RevRepContent(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public PKIStatusInfo[] getStatus() {
        PKIStatusInfo[] pKIStatusInfoArray = new PKIStatusInfo[this.status.size()];
        for (int i2 = 0; i2 != pKIStatusInfoArray.length; ++i2) {
            pKIStatusInfoArray[i2] = PKIStatusInfo.getInstance((Object)this.status.getObjectAt(i2));
        }
        return pKIStatusInfoArray;
    }

    public CertId[] getRevCerts() {
        if (this.revCerts == null) {
            return null;
        }
        CertId[] certIdArray = new CertId[this.revCerts.size()];
        for (int i2 = 0; i2 != certIdArray.length; ++i2) {
            certIdArray[i2] = CertId.getInstance((Object)this.revCerts.getObjectAt(i2));
        }
        return certIdArray;
    }

    public CertificateList[] getCrls() {
        if (this.crls == null) {
            return null;
        }
        CertificateList[] certificateListArray = new CertificateList[this.crls.size()];
        for (int i2 = 0; i2 != certificateListArray.length; ++i2) {
            certificateListArray[i2] = CertificateList.getInstance((Object)this.crls.getObjectAt(i2));
        }
        return certificateListArray;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.status);
        this.addOptional(aSN1EncodableVector, 0, (ASN1Encodable)this.revCerts);
        this.addOptional(aSN1EncodableVector, 1, (ASN1Encodable)this.crls);
        return new DERSequence(aSN1EncodableVector);
    }

    private void addOptional(ASN1EncodableVector aSN1EncodableVector, int n2, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(true, n2, aSN1Encodable));
        }
    }
}

