/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmp;

import java.util.Enumeration;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1TaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERBitString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERTaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmp.CMPCertificate;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmp.PKIBody;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmp.PKIHeader;

public class PKIMessage
extends ASN1Object {
    private PKIHeader header;
    private PKIBody body;
    private DERBitString protection;
    private ASN1Sequence extraCerts;

    private PKIMessage(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.header = PKIHeader.getInstance(enumeration.nextElement());
        this.body = PKIBody.getInstance(enumeration.nextElement());
        while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.protection = DERBitString.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)true);
                continue;
            }
            this.extraCerts = ASN1Sequence.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)true);
        }
    }

    public static PKIMessage getInstance(Object object) {
        if (object instanceof PKIMessage) {
            return (PKIMessage)object;
        }
        if (object != null) {
            return new PKIMessage(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public PKIMessage(PKIHeader pKIHeader, PKIBody pKIBody, DERBitString dERBitString, CMPCertificate[] cMPCertificateArray) {
        this.header = pKIHeader;
        this.body = pKIBody;
        this.protection = dERBitString;
        if (cMPCertificateArray != null) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            for (int i2 = 0; i2 < cMPCertificateArray.length; ++i2) {
                aSN1EncodableVector.add((ASN1Encodable)cMPCertificateArray[i2]);
            }
            this.extraCerts = new DERSequence(aSN1EncodableVector);
        }
    }

    public PKIMessage(PKIHeader pKIHeader, PKIBody pKIBody, DERBitString dERBitString) {
        this(pKIHeader, pKIBody, dERBitString, null);
    }

    public PKIMessage(PKIHeader pKIHeader, PKIBody pKIBody) {
        this(pKIHeader, pKIBody, null, null);
    }

    public PKIHeader getHeader() {
        return this.header;
    }

    public PKIBody getBody() {
        return this.body;
    }

    public DERBitString getProtection() {
        return this.protection;
    }

    public CMPCertificate[] getExtraCerts() {
        if (this.extraCerts == null) {
            return null;
        }
        CMPCertificate[] cMPCertificateArray = new CMPCertificate[this.extraCerts.size()];
        for (int i2 = 0; i2 < cMPCertificateArray.length; ++i2) {
            cMPCertificateArray[i2] = CMPCertificate.getInstance((Object)this.extraCerts.getObjectAt(i2));
        }
        return cMPCertificateArray;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.header);
        aSN1EncodableVector.add((ASN1Encodable)this.body);
        this.addOptional(aSN1EncodableVector, 0, (ASN1Encodable)this.protection);
        this.addOptional(aSN1EncodableVector, 1, (ASN1Encodable)this.extraCerts);
        return new DERSequence(aSN1EncodableVector);
    }

    private void addOptional(ASN1EncodableVector aSN1EncodableVector, int n2, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(true, n2, aSN1Encodable));
        }
    }
}

