/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmp;

import java.util.Enumeration;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1TaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERTaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmp.CMPCertificate;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmp.CertifiedKeyPair;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmp.PKIStatusInfo;

public class KeyRecRepContent
extends ASN1Object {
    private PKIStatusInfo status;
    private CMPCertificate newSigCert;
    private ASN1Sequence caCerts;
    private ASN1Sequence keyPairHist;

    private KeyRecRepContent(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.status = PKIStatusInfo.getInstance(enumeration.nextElement());
        block5: while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(enumeration.nextElement());
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.newSigCert = CMPCertificate.getInstance((Object)aSN1TaggedObject.getObject());
                    continue block5;
                }
                case 1: {
                    this.caCerts = ASN1Sequence.getInstance((Object)aSN1TaggedObject.getObject());
                    continue block5;
                }
                case 2: {
                    this.keyPairHist = ASN1Sequence.getInstance((Object)aSN1TaggedObject.getObject());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("unknown tag number: " + aSN1TaggedObject.getTagNo());
        }
    }

    public static KeyRecRepContent getInstance(Object object) {
        if (object instanceof KeyRecRepContent) {
            return (KeyRecRepContent)object;
        }
        if (object != null) {
            return new KeyRecRepContent(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public PKIStatusInfo getStatus() {
        return this.status;
    }

    public CMPCertificate getNewSigCert() {
        return this.newSigCert;
    }

    public CMPCertificate[] getCaCerts() {
        if (this.caCerts == null) {
            return null;
        }
        CMPCertificate[] cMPCertificateArray = new CMPCertificate[this.caCerts.size()];
        for (int i2 = 0; i2 != cMPCertificateArray.length; ++i2) {
            cMPCertificateArray[i2] = CMPCertificate.getInstance((Object)this.caCerts.getObjectAt(i2));
        }
        return cMPCertificateArray;
    }

    public CertifiedKeyPair[] getKeyPairHist() {
        if (this.keyPairHist == null) {
            return null;
        }
        CertifiedKeyPair[] certifiedKeyPairArray = new CertifiedKeyPair[this.keyPairHist.size()];
        for (int i2 = 0; i2 != certifiedKeyPairArray.length; ++i2) {
            certifiedKeyPairArray[i2] = CertifiedKeyPair.getInstance((Object)this.keyPairHist.getObjectAt(i2));
        }
        return certifiedKeyPairArray;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.status);
        this.addOptional(aSN1EncodableVector, 0, (ASN1Encodable)this.newSigCert);
        this.addOptional(aSN1EncodableVector, 1, (ASN1Encodable)this.caCerts);
        this.addOptional(aSN1EncodableVector, 2, (ASN1Encodable)this.keyPairHist);
        return new DERSequence(aSN1EncodableVector);
    }

    private void addOptional(ASN1EncodableVector aSN1EncodableVector, int n2, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(true, n2, aSN1Encodable));
        }
    }
}

