/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc;

import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1OctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DEROctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class PublishTrustAnchors
extends ASN1Object {
    private final ASN1Integer seqNumber;
    private final AlgorithmIdentifier hashAlgorithm;
    private final ASN1Sequence anchorHashes;

    public PublishTrustAnchors(BigInteger bigInteger, AlgorithmIdentifier algorithmIdentifier, byte[][] byArray) {
        this.seqNumber = new ASN1Integer(bigInteger);
        this.hashAlgorithm = algorithmIdentifier;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            aSN1EncodableVector.add((ASN1Encodable)new DEROctetString(Arrays.clone((byte[])byArray[i2])));
        }
        this.anchorHashes = new DERSequence(aSN1EncodableVector);
    }

    private PublishTrustAnchors(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.seqNumber = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(0));
        this.hashAlgorithm = AlgorithmIdentifier.getInstance((Object)aSN1Sequence.getObjectAt(1));
        this.anchorHashes = ASN1Sequence.getInstance((Object)aSN1Sequence.getObjectAt(2));
    }

    public static PublishTrustAnchors getInstance(Object object) {
        if (object instanceof PublishTrustAnchors) {
            return (PublishTrustAnchors)object;
        }
        if (object != null) {
            return new PublishTrustAnchors(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public BigInteger getSeqNumber() {
        return this.seqNumber.getValue();
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public byte[][] getAnchorHashes() {
        byte[][] byArrayArray = new byte[this.anchorHashes.size()][];
        for (int i2 = 0; i2 != byArrayArray.length; ++i2) {
            byArrayArray[i2] = Arrays.clone((byte[])ASN1OctetString.getInstance((Object)this.anchorHashes.getObjectAt(i2)).getOctets());
        }
        return byArrayArray;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.seqNumber);
        aSN1EncodableVector.add((ASN1Encodable)this.hashAlgorithm);
        aSN1EncodableVector.add((ASN1Encodable)this.anchorHashes);
        return new DERSequence(aSN1EncodableVector);
    }
}

