/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc;

import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc.OtherMsg;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc.TaggedAttribute;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc.TaggedContentInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc.TaggedRequest;

public class PKIData
extends ASN1Object {
    private final TaggedAttribute[] controlSequence;
    private final TaggedRequest[] reqSequence;
    private final TaggedContentInfo[] cmsSequence;
    private final OtherMsg[] otherMsgSequence;

    public PKIData(TaggedAttribute[] taggedAttributeArray, TaggedRequest[] taggedRequestArray, TaggedContentInfo[] taggedContentInfoArray, OtherMsg[] otherMsgArray) {
        this.controlSequence = taggedAttributeArray;
        this.reqSequence = taggedRequestArray;
        this.cmsSequence = taggedContentInfoArray;
        this.otherMsgSequence = otherMsgArray;
    }

    private PKIData(ASN1Sequence aSN1Sequence) {
        int n2;
        if (aSN1Sequence.size() != 4) {
            throw new IllegalArgumentException("Sequence not 4 elements.");
        }
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(0);
        this.controlSequence = new TaggedAttribute[aSN1Sequence2.size()];
        for (n2 = 0; n2 < this.controlSequence.length; ++n2) {
            this.controlSequence[n2] = TaggedAttribute.getInstance((Object)aSN1Sequence2.getObjectAt(n2));
        }
        aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(1);
        this.reqSequence = new TaggedRequest[aSN1Sequence2.size()];
        for (n2 = 0; n2 < this.reqSequence.length; ++n2) {
            this.reqSequence[n2] = TaggedRequest.getInstance((Object)aSN1Sequence2.getObjectAt(n2));
        }
        aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(2);
        this.cmsSequence = new TaggedContentInfo[aSN1Sequence2.size()];
        for (n2 = 0; n2 < this.cmsSequence.length; ++n2) {
            this.cmsSequence[n2] = TaggedContentInfo.getInstance((Object)aSN1Sequence2.getObjectAt(n2));
        }
        aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(3);
        this.otherMsgSequence = new OtherMsg[aSN1Sequence2.size()];
        for (n2 = 0; n2 < this.otherMsgSequence.length; ++n2) {
            this.otherMsgSequence[n2] = OtherMsg.getInstance((Object)aSN1Sequence2.getObjectAt(n2));
        }
    }

    public static PKIData getInstance(Object object) {
        if (object instanceof PKIData) {
            return (PKIData)object;
        }
        if (object != null) {
            return new PKIData(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(new ASN1Encodable[]{new DERSequence((ASN1Encodable[])this.controlSequence), new DERSequence((ASN1Encodable[])this.reqSequence), new DERSequence((ASN1Encodable[])this.cmsSequence), new DERSequence((ASN1Encodable[])this.otherMsgSequence)});
    }

    public TaggedAttribute[] getControlSequence() {
        return this.controlSequence;
    }

    public TaggedRequest[] getReqSequence() {
        return this.reqSequence;
    }

    public TaggedContentInfo[] getCmsSequence() {
        return this.cmsSequence;
    }

    public OtherMsg[] getOtherMsgSequence() {
        return this.otherMsgSequence;
    }
}

