/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc;

import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1GeneralizedTime;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1TaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERBitString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x500.X500Name;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.GeneralName;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.ReasonFlags;

public class GetCRL
extends ASN1Object {
    private final X500Name issuerName;
    private GeneralName cRLName;
    private ASN1GeneralizedTime time;
    private ReasonFlags reasons;

    public GetCRL(X500Name x500Name, GeneralName generalName, ASN1GeneralizedTime aSN1GeneralizedTime, ReasonFlags reasonFlags) {
        this.issuerName = x500Name;
        this.cRLName = generalName;
        this.time = aSN1GeneralizedTime;
        this.reasons = reasonFlags;
    }

    private GetCRL(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 1 || aSN1Sequence.size() > 4) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.issuerName = X500Name.getInstance((Object)aSN1Sequence.getObjectAt(0));
        int n2 = 1;
        if (aSN1Sequence.size() > n2 && aSN1Sequence.getObjectAt(n2).toASN1Primitive() instanceof ASN1TaggedObject) {
            this.cRLName = GeneralName.getInstance((Object)aSN1Sequence.getObjectAt(n2++));
        }
        if (aSN1Sequence.size() > n2 && aSN1Sequence.getObjectAt(n2).toASN1Primitive() instanceof ASN1GeneralizedTime) {
            this.time = ASN1GeneralizedTime.getInstance((Object)aSN1Sequence.getObjectAt(n2++));
        }
        if (aSN1Sequence.size() > n2 && aSN1Sequence.getObjectAt(n2).toASN1Primitive() instanceof DERBitString) {
            this.reasons = new ReasonFlags(DERBitString.getInstance((Object)aSN1Sequence.getObjectAt(n2)));
        }
    }

    public static GetCRL getInstance(Object object) {
        if (object instanceof GetCRL) {
            return (GetCRL)object;
        }
        if (object != null) {
            return new GetCRL(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public X500Name getIssuerName() {
        return this.issuerName;
    }

    public GeneralName getcRLName() {
        return this.cRLName;
    }

    public ASN1GeneralizedTime getTime() {
        return this.time;
    }

    public ReasonFlags getReasons() {
        return this.reasons;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.issuerName);
        if (this.cRLName != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.cRLName);
        }
        if (this.time != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.time);
        }
        if (this.reasons != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.reasons);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

