/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc;

import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERUTF8String;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc.BodyPartID;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc.CMCFailInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc.CMCStatus;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc.CMCStatusInfoV2;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc.ExtendedFailInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc.OtherStatusInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc.PendInfo;

public class CMCStatusInfoV2Builder {
    private final CMCStatus cMCStatus;
    private final ASN1Sequence bodyList;
    private DERUTF8String statusString;
    private OtherStatusInfo otherInfo;

    public CMCStatusInfoV2Builder(CMCStatus cMCStatus, BodyPartID bodyPartID) {
        this.cMCStatus = cMCStatus;
        this.bodyList = new DERSequence((ASN1Encodable)bodyPartID);
    }

    public CMCStatusInfoV2Builder(CMCStatus cMCStatus, BodyPartID[] bodyPartIDArray) {
        this.cMCStatus = cMCStatus;
        this.bodyList = new DERSequence((ASN1Encodable[])bodyPartIDArray);
    }

    public CMCStatusInfoV2Builder setStatusString(String string) {
        this.statusString = new DERUTF8String(string);
        return this;
    }

    public CMCStatusInfoV2Builder setOtherInfo(CMCFailInfo cMCFailInfo) {
        this.otherInfo = new OtherStatusInfo(cMCFailInfo);
        return this;
    }

    public CMCStatusInfoV2Builder setOtherInfo(ExtendedFailInfo extendedFailInfo) {
        this.otherInfo = new OtherStatusInfo(extendedFailInfo);
        return this;
    }

    public CMCStatusInfoV2Builder setOtherInfo(PendInfo pendInfo) {
        this.otherInfo = new OtherStatusInfo(pendInfo);
        return this;
    }

    public CMCStatusInfoV2 build() {
        return new CMCStatusInfoV2(this.cMCStatus, this.bodyList, this.statusString, this.otherInfo);
    }
}

