/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc;

import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERUTF8String;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc.BodyPartID;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc.CMCStatus;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc.CMCStatusInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc.Utils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CMCStatusInfo
extends ASN1Object {
    private final CMCStatus cMCStatus;
    private final ASN1Sequence bodyList;
    private final DERUTF8String statusString;
    private final OtherInfo otherInfo;

    CMCStatusInfo(CMCStatus cMCStatus, ASN1Sequence aSN1Sequence, DERUTF8String dERUTF8String, OtherInfo otherInfo) {
        this.cMCStatus = cMCStatus;
        this.bodyList = aSN1Sequence;
        this.statusString = dERUTF8String;
        this.otherInfo = otherInfo;
    }

    private CMCStatusInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 2 || aSN1Sequence.size() > 4) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.cMCStatus = CMCStatus.getInstance((Object)aSN1Sequence.getObjectAt(0));
        this.bodyList = ASN1Sequence.getInstance((Object)aSN1Sequence.getObjectAt(1));
        if (aSN1Sequence.size() > 3) {
            this.statusString = DERUTF8String.getInstance((Object)aSN1Sequence.getObjectAt(2));
            this.otherInfo = OtherInfo.access$000((Object)aSN1Sequence.getObjectAt(3));
        } else if (aSN1Sequence.size() > 2) {
            if (aSN1Sequence.getObjectAt(2) instanceof DERUTF8String) {
                this.statusString = DERUTF8String.getInstance((Object)aSN1Sequence.getObjectAt(2));
                this.otherInfo = null;
            } else {
                this.statusString = null;
                this.otherInfo = OtherInfo.access$000((Object)aSN1Sequence.getObjectAt(2));
            }
        } else {
            this.statusString = null;
            this.otherInfo = null;
        }
    }

    public static CMCStatusInfo getInstance(Object object) {
        if (object instanceof CMCStatusInfo) {
            return (CMCStatusInfo)object;
        }
        if (object != null) {
            return new CMCStatusInfo(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.cMCStatus);
        aSN1EncodableVector.add((ASN1Encodable)this.bodyList);
        if (this.statusString != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.statusString);
        }
        if (this.otherInfo != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.otherInfo);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public CMCStatus getCMCStatus() {
        return this.cMCStatus;
    }

    public BodyPartID[] getBodyList() {
        return Utils.toBodyPartIDArray((ASN1Sequence)this.bodyList);
    }

    public DERUTF8String getStatusString() {
        return this.statusString;
    }

    public boolean hasOtherInfo() {
        return this.otherInfo != null;
    }

    public OtherInfo getOtherInfo() {
        return this.otherInfo;
    }
}

