/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmc;

import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1OctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DEROctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.crmf.PKIPublicationInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class CMCPublicationInfo
extends ASN1Object {
    private final AlgorithmIdentifier hashAlg;
    private final ASN1Sequence certHashes;
    private final PKIPublicationInfo pubInfo;

    public CMCPublicationInfo(AlgorithmIdentifier algorithmIdentifier, byte[][] byArray, PKIPublicationInfo pKIPublicationInfo) {
        this.hashAlg = algorithmIdentifier;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            aSN1EncodableVector.add((ASN1Encodable)new DEROctetString(Arrays.clone((byte[])byArray[i2])));
        }
        this.certHashes = new DERSequence(aSN1EncodableVector);
        this.pubInfo = pKIPublicationInfo;
    }

    private CMCPublicationInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.hashAlg = AlgorithmIdentifier.getInstance((Object)aSN1Sequence.getObjectAt(0));
        this.certHashes = ASN1Sequence.getInstance((Object)aSN1Sequence.getObjectAt(1));
        this.pubInfo = PKIPublicationInfo.getInstance((Object)aSN1Sequence.getObjectAt(2));
    }

    public static CMCPublicationInfo getInstance(Object object) {
        if (object instanceof CMCPublicationInfo) {
            return (CMCPublicationInfo)object;
        }
        if (object != null) {
            return new CMCPublicationInfo(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public AlgorithmIdentifier getHashAlg() {
        return this.hashAlg;
    }

    public byte[][] getCertHashes() {
        byte[][] byArrayArray = new byte[this.certHashes.size()][];
        for (int i2 = 0; i2 != byArrayArray.length; ++i2) {
            byArrayArray[i2] = Arrays.clone((byte[])ASN1OctetString.getInstance((Object)this.certHashes.getObjectAt(i2)).getOctets());
        }
        return byArrayArray;
    }

    public PKIPublicationInfo getPubInfo() {
        return this.pubInfo;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.hashAlg);
        aSN1EncodableVector.add((ASN1Encodable)this.certHashes);
        aSN1EncodableVector.add((ASN1Encodable)this.pubInfo);
        return new DERSequence(aSN1EncodableVector);
    }
}

