/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.bc;

import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.EncryptedPrivateKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Certificate;

public class EncryptedPrivateKeyData
extends ASN1Object {
    private final EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
    private final Certificate[] certificateChain;

    public EncryptedPrivateKeyData(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, Certificate[] certificateArray) {
        this.encryptedPrivateKeyInfo = encryptedPrivateKeyInfo;
        this.certificateChain = new Certificate[certificateArray.length];
        System.arraycopy(certificateArray, 0, this.certificateChain, 0, certificateArray.length);
    }

    private EncryptedPrivateKeyData(ASN1Sequence aSN1Sequence) {
        this.encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.getInstance((Object)aSN1Sequence.getObjectAt(0));
        ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance((Object)aSN1Sequence.getObjectAt(1));
        this.certificateChain = new Certificate[aSN1Sequence2.size()];
        for (int i2 = 0; i2 != this.certificateChain.length; ++i2) {
            this.certificateChain[i2] = Certificate.getInstance((Object)aSN1Sequence2.getObjectAt(i2));
        }
    }

    public static EncryptedPrivateKeyData getInstance(Object object) {
        if (object instanceof EncryptedPrivateKeyData) {
            return (EncryptedPrivateKeyData)object;
        }
        if (object != null) {
            return new EncryptedPrivateKeyData(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public Certificate[] getCertificateChain() {
        Certificate[] certificateArray = new Certificate[this.certificateChain.length];
        System.arraycopy(this.certificateChain, 0, certificateArray, 0, this.certificateChain.length);
        return certificateArray;
    }

    public EncryptedPrivateKeyInfo getEncryptedPrivateKeyInfo() {
        return this.encryptedPrivateKeyInfo;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.encryptedPrivateKeyInfo);
        aSN1EncodableVector.add((ASN1Encodable)new DERSequence((ASN1Encodable[])this.certificateChain));
        return new DERSequence(aSN1EncodableVector);
    }
}

