/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.apache.commons_3_5.lang3.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import macromedia.externals.org.apache.commons_3_5.lang3.exception.ExceptionUtils;
import macromedia.externals.org.apache.commons_3_5.lang3.time.DatePrinter;
import macromedia.externals.org.apache.commons_3_5.lang3.time.FastDatePrinter;

/*
 * Exception performing whole class analysis ignored.
 */
public class FastDatePrinter
implements DatePrinter,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    private final String mPattern;
    private final TimeZone mTimeZone;
    private final Locale mLocale;
    private transient Rule[] mRules;
    private transient int mMaxLengthEstimate;
    private static final int MAX_DIGITS = 10;
    private static final ConcurrentMap<TimeZoneDisplayKey, String> cTimeZoneDisplayCache = new ConcurrentHashMap(7);

    protected FastDatePrinter(String string, TimeZone timeZone, Locale locale) {
        this.mPattern = string;
        this.mTimeZone = timeZone;
        this.mLocale = locale;
        this.init();
    }

    private void init() {
        List list = this.parsePattern();
        this.mRules = list.toArray(new Rule[list.size()]);
        int n2 = 0;
        int n3 = this.mRules.length;
        while (--n3 >= 0) {
            n2 += this.mRules[n3].estimateLength();
        }
        this.mMaxLengthEstimate = n2;
    }

    protected List<Rule> parsePattern() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.mLocale);
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        String[] stringArray = dateFormatSymbols.getEras();
        String[] stringArray2 = dateFormatSymbols.getMonths();
        String[] stringArray3 = dateFormatSymbols.getShortMonths();
        String[] stringArray4 = dateFormatSymbols.getWeekdays();
        String[] stringArray5 = dateFormatSymbols.getShortWeekdays();
        String[] stringArray6 = dateFormatSymbols.getAmPmStrings();
        int n2 = this.mPattern.length();
        int[] nArray = new int[1];
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            nArray[0] = i2;
            String string = this.parseToken(this.mPattern, nArray);
            i2 = nArray[0];
            int n3 = string.length();
            if (n3 == 0) break;
            char c2 = string.charAt(0);
            switch (c2) {
                case 'G': {
                    object = new TextField(0, stringArray);
                    break;
                }
                case 'Y': 
                case 'y': {
                    object = n3 == 2 ? TwoDigitYearField.INSTANCE : this.selectNumberRule(1, n3 < 4 ? 4 : n3);
                    if (c2 != 'Y') break;
                    object = new WeekYear((NumberRule)object);
                    break;
                }
                case 'M': {
                    if (n3 >= 4) {
                        object = new TextField(2, stringArray2);
                        break;
                    }
                    if (n3 == 3) {
                        object = new TextField(2, stringArray3);
                        break;
                    }
                    if (n3 == 2) {
                        object = TwoDigitMonthField.INSTANCE;
                        break;
                    }
                    object = UnpaddedMonthField.INSTANCE;
                    break;
                }
                case 'd': {
                    object = this.selectNumberRule(5, n3);
                    break;
                }
                case 'h': {
                    object = new TwelveHourField(this.selectNumberRule(10, n3));
                    break;
                }
                case 'H': {
                    object = this.selectNumberRule(11, n3);
                    break;
                }
                case 'm': {
                    object = this.selectNumberRule(12, n3);
                    break;
                }
                case 's': {
                    object = this.selectNumberRule(13, n3);
                    break;
                }
                case 'S': {
                    object = this.selectNumberRule(14, n3);
                    break;
                }
                case 'E': {
                    object = new TextField(7, n3 < 4 ? stringArray5 : stringArray4);
                    break;
                }
                case 'u': {
                    object = new DayInWeekField(this.selectNumberRule(7, n3));
                    break;
                }
                case 'D': {
                    object = this.selectNumberRule(6, n3);
                    break;
                }
                case 'F': {
                    object = this.selectNumberRule(8, n3);
                    break;
                }
                case 'w': {
                    object = this.selectNumberRule(3, n3);
                    break;
                }
                case 'W': {
                    object = this.selectNumberRule(4, n3);
                    break;
                }
                case 'a': {
                    object = new TextField(9, stringArray6);
                    break;
                }
                case 'k': {
                    object = new TwentyFourHourField(this.selectNumberRule(11, n3));
                    break;
                }
                case 'K': {
                    object = this.selectNumberRule(10, n3);
                    break;
                }
                case 'X': {
                    object = Iso8601_Rule.getRule((int)n3);
                    break;
                }
                case 'z': {
                    if (n3 >= 4) {
                        object = new TimeZoneNameRule(this.mTimeZone, this.mLocale, 1);
                        break;
                    }
                    object = new TimeZoneNameRule(this.mTimeZone, this.mLocale, 0);
                    break;
                }
                case 'Z': {
                    if (n3 == 1) {
                        object = TimeZoneNumberRule.INSTANCE_NO_COLON;
                        break;
                    }
                    if (n3 == 2) {
                        object = Iso8601_Rule.ISO8601_HOURS_COLON_MINUTES;
                        break;
                    }
                    object = TimeZoneNumberRule.INSTANCE_COLON;
                    break;
                }
                case '\'': {
                    String string2 = string.substring(1);
                    if (string2.length() == 1) {
                        object = new CharacterLiteral(string2.charAt(0));
                        break;
                    }
                    object = new StringLiteral(string2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + string);
                }
            }
            arrayList.add((Rule)object);
        }
        return arrayList;
    }

    protected String parseToken(String string, int[] nArray) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = string.length();
        char c2 = string.charAt(n2);
        if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
            char c3;
            stringBuilder.append(c2);
            while (n2 + 1 < n3 && (c3 = string.charAt(n2 + 1)) == c2) {
                stringBuilder.append(c2);
                ++n2;
            }
        } else {
            stringBuilder.append('\'');
            boolean bl2 = false;
            for (n2 = nArray[0]; n2 < n3; ++n2) {
                c2 = string.charAt(n2);
                if (c2 == '\'') {
                    if (n2 + 1 < n3 && string.charAt(n2 + 1) == '\'') {
                        ++n2;
                        stringBuilder.append(c2);
                        continue;
                    }
                    bl2 = !bl2;
                    continue;
                }
                if (bl2 || (c2 < 'A' || c2 > 'Z') && (c2 < 'a' || c2 > 'z')) {
                    stringBuilder.append(c2);
                    continue;
                }
                break;
            }
        }
        nArray[0] = --n2;
        return stringBuilder.toString();
    }

    protected NumberRule selectNumberRule(int n2, int n3) {
        switch (n3) {
            case 1: {
                return new UnpaddedNumberField(n2);
            }
            case 2: {
                return new TwoDigitNumberField(n2);
            }
        }
        return new PaddedNumberField(n2, n3);
    }

    @Deprecated
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Date) {
            return this.format((Date)object, stringBuffer);
        }
        if (object instanceof Calendar) {
            return this.format((Calendar)object, stringBuffer);
        }
        if (object instanceof Long) {
            return this.format(((Long)object).longValue(), stringBuffer);
        }
        throw new IllegalArgumentException("Unknown class: " + (object == null ? "<null>" : object.getClass().getName()));
    }

    String format(Object object) {
        if (object instanceof Date) {
            return this.format((Date)object);
        }
        if (object instanceof Calendar) {
            return this.format((Calendar)object);
        }
        if (object instanceof Long) {
            return this.format(((Long)object).longValue());
        }
        throw new IllegalArgumentException("Unknown class: " + (object == null ? "<null>" : object.getClass().getName()));
    }

    public String format(long l2) {
        Calendar calendar = this.newCalendar();
        calendar.setTimeInMillis(l2);
        return this.applyRulesToString(calendar);
    }

    private String applyRulesToString(Calendar calendar) {
        return ((StringBuilder)this.applyRules(calendar, (Appendable)new StringBuilder(this.mMaxLengthEstimate))).toString();
    }

    private Calendar newCalendar() {
        return Calendar.getInstance(this.mTimeZone, this.mLocale);
    }

    public String format(Date date) {
        Calendar calendar = this.newCalendar();
        calendar.setTime(date);
        return this.applyRulesToString(calendar);
    }

    public String format(Calendar calendar) {
        return ((StringBuilder)this.format(calendar, (Appendable)new StringBuilder(this.mMaxLengthEstimate))).toString();
    }

    public StringBuffer format(long l2, StringBuffer stringBuffer) {
        Calendar calendar = this.newCalendar();
        calendar.setTimeInMillis(l2);
        return (StringBuffer)this.applyRules(calendar, (Appendable)stringBuffer);
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer) {
        Calendar calendar = this.newCalendar();
        calendar.setTime(date);
        return (StringBuffer)this.applyRules(calendar, (Appendable)stringBuffer);
    }

    public StringBuffer format(Calendar calendar, StringBuffer stringBuffer) {
        return this.format(calendar.getTime(), stringBuffer);
    }

    public <B extends Appendable> B format(long l2, B b2) {
        Calendar calendar = this.newCalendar();
        calendar.setTimeInMillis(l2);
        return (B)this.applyRules(calendar, b2);
    }

    public <B extends Appendable> B format(Date date, B b2) {
        Calendar calendar = this.newCalendar();
        calendar.setTime(date);
        return (B)this.applyRules(calendar, b2);
    }

    public <B extends Appendable> B format(Calendar calendar, B b2) {
        if (!calendar.getTimeZone().equals(this.mTimeZone)) {
            calendar = (Calendar)calendar.clone();
            calendar.setTimeZone(this.mTimeZone);
        }
        return (B)this.applyRules(calendar, b2);
    }

    @Deprecated
    protected StringBuffer applyRules(Calendar calendar, StringBuffer stringBuffer) {
        return (StringBuffer)this.applyRules(calendar, (Appendable)stringBuffer);
    }

    private <B extends Appendable> B applyRules(Calendar calendar, B b2) {
        try {
            for (Rule rule : this.mRules) {
                rule.appendTo(b2, calendar);
            }
        }
        catch (IOException iOException) {
            ExceptionUtils.rethrow((Throwable)iOException);
        }
        return b2;
    }

    public String getPattern() {
        return this.mPattern;
    }

    public TimeZone getTimeZone() {
        return this.mTimeZone;
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public int getMaxLengthEstimate() {
        return this.mMaxLengthEstimate;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FastDatePrinter)) {
            return false;
        }
        FastDatePrinter fastDatePrinter = (FastDatePrinter)object;
        return this.mPattern.equals(fastDatePrinter.mPattern) && this.mTimeZone.equals(fastDatePrinter.mTimeZone) && this.mLocale.equals(fastDatePrinter.mLocale);
    }

    public int hashCode() {
        return this.mPattern.hashCode() + 13 * (this.mTimeZone.hashCode() + 13 * this.mLocale.hashCode());
    }

    public String toString() {
        return "FastDatePrinter[" + this.mPattern + "," + this.mLocale + "," + this.mTimeZone.getID() + "]";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    private static void appendDigits(Appendable appendable, int n2) throws IOException {
        appendable.append((char)(n2 / 10 + 48));
        appendable.append((char)(n2 % 10 + 48));
    }

    private static void appendFullDigits(Appendable appendable, int n2, int n3) throws IOException {
        if (n2 < 10000) {
            int n4 = 4;
            if (n2 < 1000) {
                --n4;
                if (n2 < 100) {
                    --n4;
                    if (n2 < 10) {
                        --n4;
                    }
                }
            }
            for (int i2 = n3 - n4; i2 > 0; --i2) {
                appendable.append('0');
            }
            switch (n4) {
                case 4: {
                    appendable.append((char)(n2 / 1000 + 48));
                    n2 %= 1000;
                }
                case 3: {
                    if (n2 >= 100) {
                        appendable.append((char)(n2 / 100 + 48));
                        n2 %= 100;
                    } else {
                        appendable.append('0');
                    }
                }
                case 2: {
                    if (n2 >= 10) {
                        appendable.append((char)(n2 / 10 + 48));
                        n2 %= 10;
                    } else {
                        appendable.append('0');
                    }
                }
                case 1: {
                    appendable.append((char)(n2 + 48));
                }
            }
        } else {
            char[] cArray = new char[10];
            int n5 = 0;
            while (n2 != 0) {
                cArray[n5++] = (char)(n2 % 10 + 48);
                n2 /= 10;
            }
            while (n5 < n3) {
                appendable.append('0');
                --n3;
            }
            while (--n5 >= 0) {
                appendable.append(cArray[n5]);
            }
        }
    }

    static String getTimeZoneDisplay(TimeZone timeZone, boolean bl2, int n2, Locale locale) {
        String string;
        TimeZoneDisplayKey timeZoneDisplayKey = new TimeZoneDisplayKey(timeZone, bl2, n2, locale);
        String string2 = (String)cTimeZoneDisplayCache.get(timeZoneDisplayKey);
        if (string2 == null && (string = cTimeZoneDisplayCache.putIfAbsent(timeZoneDisplayKey, string2 = timeZone.getDisplayName(bl2, n2, locale))) != null) {
            string2 = string;
        }
        return string2;
    }

    static /* synthetic */ void access$000(Appendable appendable, int n2) throws IOException {
        FastDatePrinter.appendDigits((Appendable)appendable, (int)n2);
    }

    static /* synthetic */ void access$100(Appendable appendable, int n2, int n3) throws IOException {
        FastDatePrinter.appendFullDigits((Appendable)appendable, (int)n2, (int)n3);
    }
}

