/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.apache.commons_3_5.lang3.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import macromedia.externals.org.apache.commons_3_5.lang3.time.DateParser;
import macromedia.externals.org.apache.commons_3_5.lang3.time.FastDateParser;

/*
 * Exception performing whole class analysis ignored.
 */
public class FastDateParser
implements DateParser,
Serializable {
    private static final long serialVersionUID = 3L;
    static final Locale JAPANESE_IMPERIAL = new Locale("ja", "JP", "JP");
    private final String pattern;
    private final TimeZone timeZone;
    private final Locale locale;
    private final int century;
    private final int startYear;
    private transient List<StrategyAndWidth> patterns;
    private static final Comparator<String> LONGER_FIRST_LOWERCASE = new /* Unavailable Anonymous Inner Class!! */;
    private static final ConcurrentMap<Locale, Strategy>[] caches = new ConcurrentMap[17];
    private static final Strategy ABBREVIATED_YEAR_STRATEGY = new /* Unavailable Anonymous Inner Class!! */;
    private static final Strategy NUMBER_MONTH_STRATEGY = new /* Unavailable Anonymous Inner Class!! */;
    private static final Strategy LITERAL_YEAR_STRATEGY = new NumberStrategy(1);
    private static final Strategy WEEK_OF_YEAR_STRATEGY = new NumberStrategy(3);
    private static final Strategy WEEK_OF_MONTH_STRATEGY = new NumberStrategy(4);
    private static final Strategy DAY_OF_YEAR_STRATEGY = new NumberStrategy(6);
    private static final Strategy DAY_OF_MONTH_STRATEGY = new NumberStrategy(5);
    private static final Strategy DAY_OF_WEEK_STRATEGY = new /* Unavailable Anonymous Inner Class!! */;
    private static final Strategy DAY_OF_WEEK_IN_MONTH_STRATEGY = new NumberStrategy(8);
    private static final Strategy HOUR_OF_DAY_STRATEGY = new NumberStrategy(11);
    private static final Strategy HOUR24_OF_DAY_STRATEGY = new /* Unavailable Anonymous Inner Class!! */;
    private static final Strategy HOUR12_STRATEGY = new /* Unavailable Anonymous Inner Class!! */;
    private static final Strategy HOUR_STRATEGY = new NumberStrategy(10);
    private static final Strategy MINUTE_STRATEGY = new NumberStrategy(12);
    private static final Strategy SECOND_STRATEGY = new NumberStrategy(13);
    private static final Strategy MILLISECOND_STRATEGY = new NumberStrategy(14);

    protected FastDateParser(String string, TimeZone timeZone, Locale locale) {
        this(string, timeZone, locale, null);
    }

    protected FastDateParser(String string, TimeZone timeZone, Locale locale, Date date) {
        int n2;
        this.pattern = string;
        this.timeZone = timeZone;
        this.locale = locale;
        Calendar calendar = Calendar.getInstance(timeZone, locale);
        if (date != null) {
            calendar.setTime(date);
            n2 = calendar.get(1);
        } else if (locale.equals(JAPANESE_IMPERIAL)) {
            n2 = 0;
        } else {
            calendar.setTime(new Date());
            n2 = calendar.get(1) - 80;
        }
        this.century = n2 / 100 * 100;
        this.startYear = n2 - this.century;
        this.init(calendar);
    }

    private void init(Calendar calendar) {
        StrategyAndWidth strategyAndWidth;
        this.patterns = new ArrayList();
        StrategyParser strategyParser = new StrategyParser(this, this.pattern, calendar);
        while ((strategyAndWidth = strategyParser.getNextStrategy()) != null) {
            this.patterns.add(strategyAndWidth);
        }
    }

    private static boolean isFormatLetter(char c2) {
        return c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z';
    }

    public String getPattern() {
        return this.pattern;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FastDateParser)) {
            return false;
        }
        FastDateParser fastDateParser = (FastDateParser)object;
        return this.pattern.equals(fastDateParser.pattern) && this.timeZone.equals(fastDateParser.timeZone) && this.locale.equals(fastDateParser.locale);
    }

    public int hashCode() {
        return this.pattern.hashCode() + 13 * (this.timeZone.hashCode() + 13 * this.locale.hashCode());
    }

    public String toString() {
        return "FastDateParser[" + this.pattern + "," + this.locale + "," + this.timeZone.getID() + "]";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        this.init(calendar);
    }

    public Object parseObject(String string) throws ParseException {
        return this.parse(string);
    }

    public Date parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = this.parse(string, parsePosition);
        if (date == null) {
            if (this.locale.equals(JAPANESE_IMPERIAL)) {
                throw new ParseException("(The " + this.locale + " locale does not support dates before 1868 AD)\nUnparseable date: \"" + string, parsePosition.getErrorIndex());
            }
            throw new ParseException("Unparseable date: " + string, parsePosition.getErrorIndex());
        }
        return date;
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public Date parse(String string, ParsePosition parsePosition) {
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        calendar.clear();
        return this.parse(string, parsePosition, calendar) ? calendar.getTime() : null;
    }

    public boolean parse(String string, ParsePosition parsePosition, Calendar calendar) {
        ListIterator listIterator = this.patterns.listIterator();
        while (listIterator.hasNext()) {
            StrategyAndWidth strategyAndWidth = (StrategyAndWidth)listIterator.next();
            int n2 = strategyAndWidth.getMaxWidth(listIterator);
            if (strategyAndWidth.strategy.parse(this, calendar, string, parsePosition, n2)) continue;
            return false;
        }
        return true;
    }

    private static StringBuilder simpleQuote(StringBuilder stringBuilder, String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case '^': 
                case '{': 
                case '|': {
                    stringBuilder.append('\\');
                }
            }
            stringBuilder.append(c2);
        }
        return stringBuilder;
    }

    private static Map<String, Integer> appendDisplayNames(Calendar calendar, Locale locale, int n2, StringBuilder stringBuilder) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Map<String, Integer> map = calendar.getDisplayNames(n2, 0, locale);
        TreeSet<String> treeSet = new TreeSet<String>(LONGER_FIRST_LOWERCASE);
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String string = entry.getKey().toLowerCase(locale);
            if (!treeSet.add(string)) continue;
            hashMap.put(string, entry.getValue());
        }
        for (String string : treeSet) {
            FastDateParser.simpleQuote((StringBuilder)stringBuilder, (String)string).append('|');
        }
        return hashMap;
    }

    private int adjustYear(int n2) {
        int n3 = this.century + n2;
        return n2 >= this.startYear ? n3 : n3 + 100;
    }

    private Strategy getStrategy(char c2, int n2, Calendar calendar) {
        switch (c2) {
            default: {
                throw new IllegalArgumentException("Format '" + c2 + "' not supported");
            }
            case 'D': {
                return DAY_OF_YEAR_STRATEGY;
            }
            case 'E': {
                return this.getLocaleSpecificStrategy(7, calendar);
            }
            case 'F': {
                return DAY_OF_WEEK_IN_MONTH_STRATEGY;
            }
            case 'G': {
                return this.getLocaleSpecificStrategy(0, calendar);
            }
            case 'H': {
                return HOUR_OF_DAY_STRATEGY;
            }
            case 'K': {
                return HOUR_STRATEGY;
            }
            case 'M': {
                return n2 >= 3 ? this.getLocaleSpecificStrategy(2, calendar) : NUMBER_MONTH_STRATEGY;
            }
            case 'S': {
                return MILLISECOND_STRATEGY;
            }
            case 'W': {
                return WEEK_OF_MONTH_STRATEGY;
            }
            case 'a': {
                return this.getLocaleSpecificStrategy(9, calendar);
            }
            case 'd': {
                return DAY_OF_MONTH_STRATEGY;
            }
            case 'h': {
                return HOUR12_STRATEGY;
            }
            case 'k': {
                return HOUR24_OF_DAY_STRATEGY;
            }
            case 'm': {
                return MINUTE_STRATEGY;
            }
            case 's': {
                return SECOND_STRATEGY;
            }
            case 'u': {
                return DAY_OF_WEEK_STRATEGY;
            }
            case 'w': {
                return WEEK_OF_YEAR_STRATEGY;
            }
            case 'Y': 
            case 'y': {
                return n2 > 2 ? LITERAL_YEAR_STRATEGY : ABBREVIATED_YEAR_STRATEGY;
            }
            case 'X': {
                return ISO8601TimeZoneStrategy.getStrategy((int)n2);
            }
            case 'Z': {
                if (n2 != 2) break;
                return ISO8601TimeZoneStrategy.access$300();
            }
            case 'z': 
        }
        return this.getLocaleSpecificStrategy(15, calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConcurrentMap<Locale, Strategy> getCache(int n2) {
        ConcurrentMap[] concurrentMapArray = caches;
        synchronized (caches) {
            if (caches[n2] == null) {
                FastDateParser.caches[n2] = new ConcurrentHashMap(3);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return caches[n2];
        }
    }

    private Strategy getLocaleSpecificStrategy(int n2, Calendar calendar) {
        Strategy strategy;
        ConcurrentMap concurrentMap = FastDateParser.getCache((int)n2);
        Strategy strategy2 = (Strategy)concurrentMap.get(this.locale);
        if (strategy2 == null && (strategy = concurrentMap.putIfAbsent(this.locale, strategy2 = n2 == 15 ? new TimeZoneStrategy(this.locale) : new CaseInsensitiveTextStrategy(n2, calendar, this.locale))) != null) {
            return strategy;
        }
        return strategy2;
    }

    static /* synthetic */ boolean access$000(char c2) {
        return FastDateParser.isFormatLetter((char)c2);
    }

    static /* synthetic */ Strategy access$100(FastDateParser fastDateParser, char c2, int n2, Calendar calendar) {
        return fastDateParser.getStrategy(c2, n2, calendar);
    }

    static /* synthetic */ Map access$500(Calendar calendar, Locale locale, int n2, StringBuilder stringBuilder) {
        return FastDateParser.appendDisplayNames((Calendar)calendar, (Locale)locale, (int)n2, (StringBuilder)stringBuilder);
    }

    static /* synthetic */ int access$600(FastDateParser fastDateParser, int n2) {
        return fastDateParser.adjustYear(n2);
    }

    static /* synthetic */ Comparator access$700() {
        return LONGER_FIRST_LOWERCASE;
    }

    static /* synthetic */ StringBuilder access$800(StringBuilder stringBuilder, String string) {
        return FastDateParser.simpleQuote((StringBuilder)stringBuilder, (String)string);
    }
}

