/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.apache.commons_3_5.lang3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import macromedia.externals.org.apache.commons_3_5.lang3.ClassUtils;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;
import macromedia.externals.org.apache.commons_3_5.lang3.Validate;
import macromedia.externals.org.apache.commons_3_5.lang3.reflect.MemberUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FieldUtils {
    public static Field getField(Class<?> clazz, String string) {
        Field field = FieldUtils.getField(clazz, (String)string, (boolean)false);
        MemberUtils.setAccessibleWorkaround((AccessibleObject)field);
        return field;
    }

    public static Field getField(Class<?> clazz, String string, boolean bl2) {
        AnnotatedElement annotatedElement;
        Validate.isTrue((clazz != null ? 1 : 0) != 0, (String)"The class must not be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)string), (String)"The field name must not be blank/empty", (Object[])new Object[0]);
        for (annotatedElement = clazz; annotatedElement != null; annotatedElement = annotatedElement.getSuperclass()) {
            try {
                Field field = annotatedElement.getDeclaredField(string);
                if (!Modifier.isPublic(field.getModifiers())) {
                    if (!bl2) continue;
                    field.setAccessible(true);
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        annotatedElement = null;
        for (Class clazz2 : ClassUtils.getAllInterfaces(clazz)) {
            try {
                Field field = clazz2.getField(string);
                Validate.isTrue((annotatedElement == null ? 1 : 0) != 0, (String)"Reference to field %s is ambiguous relative to %s; a matching field exists on two or more implemented interfaces.", (Object[])new Object[]{string, clazz});
                annotatedElement = field;
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return annotatedElement;
    }

    public static Field getDeclaredField(Class<?> clazz, String string) {
        return FieldUtils.getDeclaredField(clazz, (String)string, (boolean)false);
    }

    public static Field getDeclaredField(Class<?> clazz, String string, boolean bl2) {
        Validate.isTrue((clazz != null ? 1 : 0) != 0, (String)"The class must not be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)string), (String)"The field name must not be blank/empty", (Object[])new Object[0]);
        try {
            Field field = clazz.getDeclaredField(string);
            if (!MemberUtils.isAccessible((Member)field)) {
                if (bl2) {
                    field.setAccessible(true);
                } else {
                    return null;
                }
            }
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Field[] getAllFields(Class<?> clazz) {
        List list = FieldUtils.getAllFieldsList(clazz);
        return list.toArray(new Field[list.size()]);
    }

    public static List<Field> getAllFieldsList(Class<?> clazz) {
        Validate.isTrue((clazz != null ? 1 : 0) != 0, (String)"The class must not be null", (Object[])new Object[0]);
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Field[] fieldArray;
            for (Field field : fieldArray = clazz2.getDeclaredFields()) {
                arrayList.add(field);
            }
        }
        return arrayList;
    }

    public static Field[] getFieldsWithAnnotation(Class<?> clazz, Class<? extends Annotation> clazz2) {
        List list = FieldUtils.getFieldsListWithAnnotation(clazz, clazz2);
        return list.toArray(new Field[list.size()]);
    }

    public static List<Field> getFieldsListWithAnnotation(Class<?> clazz, Class<? extends Annotation> clazz2) {
        Validate.isTrue((clazz2 != null ? 1 : 0) != 0, (String)"The annotation class must not be null", (Object[])new Object[0]);
        List list = FieldUtils.getAllFieldsList(clazz);
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field : list) {
            if (field.getAnnotation(clazz2) == null) continue;
            arrayList.add(field);
        }
        return arrayList;
    }

    public static Object readStaticField(Field field) throws IllegalAccessException {
        return FieldUtils.readStaticField((Field)field, (boolean)false);
    }

    public static Object readStaticField(Field field, boolean bl2) throws IllegalAccessException {
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"The field must not be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)Modifier.isStatic(field.getModifiers()), (String)"The field '%s' is not static", (Object[])new Object[]{field.getName()});
        return FieldUtils.readField((Field)field, null, (boolean)bl2);
    }

    public static Object readStaticField(Class<?> clazz, String string) throws IllegalAccessException {
        return FieldUtils.readStaticField(clazz, (String)string, (boolean)false);
    }

    public static Object readStaticField(Class<?> clazz, String string, boolean bl2) throws IllegalAccessException {
        Field field = FieldUtils.getField(clazz, (String)string, (boolean)bl2);
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"Cannot locate field '%s' on %s", (Object[])new Object[]{string, clazz});
        return FieldUtils.readStaticField((Field)field, (boolean)false);
    }

    public static Object readDeclaredStaticField(Class<?> clazz, String string) throws IllegalAccessException {
        return FieldUtils.readDeclaredStaticField(clazz, (String)string, (boolean)false);
    }

    public static Object readDeclaredStaticField(Class<?> clazz, String string, boolean bl2) throws IllegalAccessException {
        Field field = FieldUtils.getDeclaredField(clazz, (String)string, (boolean)bl2);
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"Cannot locate declared field %s.%s", (Object[])new Object[]{clazz.getName(), string});
        return FieldUtils.readStaticField((Field)field, (boolean)false);
    }

    public static Object readField(Field field, Object object) throws IllegalAccessException {
        return FieldUtils.readField((Field)field, (Object)object, (boolean)false);
    }

    public static Object readField(Field field, Object object, boolean bl2) throws IllegalAccessException {
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"The field must not be null", (Object[])new Object[0]);
        if (bl2 && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround((AccessibleObject)field);
        }
        return field.get(object);
    }

    public static Object readField(Object object, String string) throws IllegalAccessException {
        return FieldUtils.readField((Object)object, (String)string, (boolean)false);
    }

    public static Object readField(Object object, String string, boolean bl2) throws IllegalAccessException {
        Validate.isTrue((object != null ? 1 : 0) != 0, (String)"target object must not be null", (Object[])new Object[0]);
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getField(clazz, (String)string, (boolean)bl2);
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"Cannot locate field %s on %s", (Object[])new Object[]{string, clazz});
        return FieldUtils.readField((Field)field, (Object)object, (boolean)false);
    }

    public static Object readDeclaredField(Object object, String string) throws IllegalAccessException {
        return FieldUtils.readDeclaredField((Object)object, (String)string, (boolean)false);
    }

    public static Object readDeclaredField(Object object, String string, boolean bl2) throws IllegalAccessException {
        Validate.isTrue((object != null ? 1 : 0) != 0, (String)"target object must not be null", (Object[])new Object[0]);
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getDeclaredField(clazz, (String)string, (boolean)bl2);
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"Cannot locate declared field %s.%s", (Object[])new Object[]{clazz, string});
        return FieldUtils.readField((Field)field, (Object)object, (boolean)false);
    }

    public static void writeStaticField(Field field, Object object) throws IllegalAccessException {
        FieldUtils.writeStaticField((Field)field, (Object)object, (boolean)false);
    }

    public static void writeStaticField(Field field, Object object, boolean bl2) throws IllegalAccessException {
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"The field must not be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)Modifier.isStatic(field.getModifiers()), (String)"The field %s.%s is not static", (Object[])new Object[]{field.getDeclaringClass().getName(), field.getName()});
        FieldUtils.writeField((Field)field, null, (Object)object, (boolean)bl2);
    }

    public static void writeStaticField(Class<?> clazz, String string, Object object) throws IllegalAccessException {
        FieldUtils.writeStaticField(clazz, (String)string, (Object)object, (boolean)false);
    }

    public static void writeStaticField(Class<?> clazz, String string, Object object, boolean bl2) throws IllegalAccessException {
        Field field = FieldUtils.getField(clazz, (String)string, (boolean)bl2);
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"Cannot locate field %s on %s", (Object[])new Object[]{string, clazz});
        FieldUtils.writeStaticField((Field)field, (Object)object, (boolean)false);
    }

    public static void writeDeclaredStaticField(Class<?> clazz, String string, Object object) throws IllegalAccessException {
        FieldUtils.writeDeclaredStaticField(clazz, (String)string, (Object)object, (boolean)false);
    }

    public static void writeDeclaredStaticField(Class<?> clazz, String string, Object object, boolean bl2) throws IllegalAccessException {
        Field field = FieldUtils.getDeclaredField(clazz, (String)string, (boolean)bl2);
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"Cannot locate declared field %s.%s", (Object[])new Object[]{clazz.getName(), string});
        FieldUtils.writeField((Field)field, null, (Object)object, (boolean)false);
    }

    public static void writeField(Field field, Object object, Object object2) throws IllegalAccessException {
        FieldUtils.writeField((Field)field, (Object)object, (Object)object2, (boolean)false);
    }

    public static void writeField(Field field, Object object, Object object2, boolean bl2) throws IllegalAccessException {
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"The field must not be null", (Object[])new Object[0]);
        if (bl2 && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround((AccessibleObject)field);
        }
        field.set(object, object2);
    }

    public static void removeFinalModifier(Field field) {
        FieldUtils.removeFinalModifier((Field)field, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFinalModifier(Field field, boolean bl2) {
        block8: {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"The field must not be null", (Object[])new Object[0]);
            try {
                boolean bl3;
                if (!Modifier.isFinal(field.getModifiers())) break block8;
                Field field2 = Field.class.getDeclaredField("modifiers");
                boolean bl4 = bl3 = bl2 && !field2.isAccessible();
                if (bl3) {
                    field2.setAccessible(true);
                }
                try {
                    field2.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                }
                finally {
                    if (bl3) {
                        field2.setAccessible(false);
                    }
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static void writeField(Object object, String string, Object object2) throws IllegalAccessException {
        FieldUtils.writeField((Object)object, (String)string, (Object)object2, (boolean)false);
    }

    public static void writeField(Object object, String string, Object object2, boolean bl2) throws IllegalAccessException {
        Validate.isTrue((object != null ? 1 : 0) != 0, (String)"target object must not be null", (Object[])new Object[0]);
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getField(clazz, (String)string, (boolean)bl2);
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"Cannot locate declared field %s.%s", (Object[])new Object[]{clazz.getName(), string});
        FieldUtils.writeField((Field)field, (Object)object, (Object)object2, (boolean)false);
    }

    public static void writeDeclaredField(Object object, String string, Object object2) throws IllegalAccessException {
        FieldUtils.writeDeclaredField((Object)object, (String)string, (Object)object2, (boolean)false);
    }

    public static void writeDeclaredField(Object object, String string, Object object2, boolean bl2) throws IllegalAccessException {
        Validate.isTrue((object != null ? 1 : 0) != 0, (String)"target object must not be null", (Object[])new Object[0]);
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getDeclaredField(clazz, (String)string, (boolean)bl2);
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"Cannot locate declared field %s.%s", (Object[])new Object[]{clazz.getName(), string});
        FieldUtils.writeField((Field)field, (Object)object, (Object)object2, (boolean)false);
    }
}

