/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.apache.commons_3_5.lang3.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import macromedia.externals.org.apache.commons_3_5.lang3.ArrayUtils;
import macromedia.externals.org.apache.commons_3_5.lang3.ClassUtils;
import macromedia.externals.org.apache.commons_3_5.lang3.Validate;
import macromedia.externals.org.apache.commons_3_5.lang3.reflect.MemberUtils;
import macromedia.externals.org.apache.commons_3_5.lang3.reflect.MethodUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConstructorUtils {
    public static <T> T invokeConstructor(Class<T> clazz, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        objectArray = ArrayUtils.nullToEmpty((Object[])objectArray);
        Class[] classArray = ClassUtils.toClass((Object[])objectArray);
        return (T)ConstructorUtils.invokeConstructor(clazz, (Object[])objectArray, (Class[])classArray);
    }

    public static <T> T invokeConstructor(Class<T> clazz, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        objectArray = ArrayUtils.nullToEmpty((Object[])objectArray);
        Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(clazz, (Class[])(classArray = ArrayUtils.nullToEmpty((Class[])classArray)));
        if (constructor == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + clazz.getName());
        }
        if (constructor.isVarArgs()) {
            Class[] classArray2 = constructor.getParameterTypes();
            objectArray = MethodUtils.getVarArgs((Object[])objectArray, (Class[])classArray2);
        }
        return constructor.newInstance(objectArray);
    }

    public static <T> T invokeExactConstructor(Class<T> clazz, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        objectArray = ArrayUtils.nullToEmpty((Object[])objectArray);
        Class[] classArray = ClassUtils.toClass((Object[])objectArray);
        return (T)ConstructorUtils.invokeExactConstructor(clazz, (Object[])objectArray, (Class[])classArray);
    }

    public static <T> T invokeExactConstructor(Class<T> clazz, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        objectArray = ArrayUtils.nullToEmpty((Object[])objectArray);
        Constructor constructor = ConstructorUtils.getAccessibleConstructor(clazz, (Class[])(classArray = ArrayUtils.nullToEmpty((Class[])classArray)));
        if (constructor == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + clazz.getName());
        }
        return constructor.newInstance(objectArray);
    }

    public static <T> Constructor<T> getAccessibleConstructor(Class<T> clazz, Class<?> ... classArray) {
        Validate.notNull(clazz, (String)"class cannot be null", (Object[])new Object[0]);
        try {
            return ConstructorUtils.getAccessibleConstructor(clazz.getConstructor(classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static <T> Constructor<T> getAccessibleConstructor(Constructor<T> constructor) {
        Validate.notNull(constructor, (String)"constructor cannot be null", (Object[])new Object[0]);
        return MemberUtils.isAccessible(constructor) && ConstructorUtils.isAccessible(constructor.getDeclaringClass()) ? constructor : null;
    }

    public static <T> Constructor<T> getMatchingAccessibleConstructor(Class<T> clazz, Class<?> ... classArray) {
        Validate.notNull(clazz, (String)"class cannot be null", (Object[])new Object[0]);
        try {
            Constructor<T> constructor = clazz.getConstructor(classArray);
            MemberUtils.setAccessibleWorkaround(constructor);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constructor<?>[] constructorArray;
            Constructor constructor = null;
            for (Constructor<?> constructor2 : constructorArray = clazz.getConstructors()) {
                Constructor constructor3;
                Constructor constructor4;
                if (!MemberUtils.isMatchingConstructor(constructor2, (Class[])classArray) || (constructor4 = ConstructorUtils.getAccessibleConstructor(constructor2)) == null) continue;
                MemberUtils.setAccessibleWorkaround((AccessibleObject)constructor4);
                if (constructor != null && MemberUtils.compareConstructorFit((Constructor)constructor4, constructor, (Class[])classArray) >= 0) continue;
                constructor = constructor3 = constructor4;
            }
            return constructor;
        }
    }

    private static boolean isAccessible(Class<?> clazz) {
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getEnclosingClass()) {
            if (Modifier.isPublic(clazz2.getModifiers())) continue;
            return false;
        }
        return true;
    }
}

