/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.apache.commons_3_5.lang3.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;
import macromedia.externals.org.apache.commons_3_5.lang3.exception.ExceptionContext;
import macromedia.externals.org.apache.commons_3_5.lang3.exception.ExceptionUtils;
import macromedia.externals.org.apache.commons_3_5.lang3.tuple.ImmutablePair;
import macromedia.externals.org.apache.commons_3_5.lang3.tuple.Pair;

public class DefaultExceptionContext
implements ExceptionContext,
Serializable {
    private static final long serialVersionUID = 20110706L;
    private final List<Pair<String, Object>> contextValues = new ArrayList();

    public DefaultExceptionContext addContextValue(String string, Object object) {
        this.contextValues.add(new ImmutablePair((Object)string, object));
        return this;
    }

    public DefaultExceptionContext setContextValue(String string, Object object) {
        Iterator iterator = this.contextValues.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (!StringUtils.equals((CharSequence)string, (CharSequence)((CharSequence)pair.getKey()))) continue;
            iterator.remove();
        }
        this.addContextValue(string, object);
        return this;
    }

    public List<Object> getContextValues(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Pair pair : this.contextValues) {
            if (!StringUtils.equals((CharSequence)string, (CharSequence)((CharSequence)pair.getKey()))) continue;
            arrayList.add(pair.getValue());
        }
        return arrayList;
    }

    public Object getFirstContextValue(String string) {
        for (Pair pair : this.contextValues) {
            if (!StringUtils.equals((CharSequence)string, (CharSequence)((CharSequence)pair.getKey()))) continue;
            return pair.getValue();
        }
        return null;
    }

    public Set<String> getContextLabels() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Pair pair : this.contextValues) {
            hashSet.add((String)pair.getKey());
        }
        return hashSet;
    }

    public List<Pair<String, Object>> getContextEntries() {
        return this.contextValues;
    }

    public String getFormattedExceptionMessage(String string) {
        StringBuilder stringBuilder = new StringBuilder(256);
        if (string != null) {
            stringBuilder.append(string);
        }
        if (this.contextValues.size() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append("Exception Context:\n");
            int n2 = 0;
            for (Pair pair : this.contextValues) {
                stringBuilder.append("\t[");
                stringBuilder.append(++n2);
                stringBuilder.append(':');
                stringBuilder.append((String)pair.getKey());
                stringBuilder.append("=");
                Object object = pair.getValue();
                if (object == null) {
                    stringBuilder.append("null");
                } else {
                    String string2;
                    try {
                        string2 = object.toString();
                    }
                    catch (Exception exception) {
                        string2 = "Exception thrown on toString(): " + ExceptionUtils.getStackTrace((Throwable)exception);
                    }
                    stringBuilder.append(string2);
                }
                stringBuilder.append("]\n");
            }
            stringBuilder.append("---------------------------------");
        }
        return stringBuilder.toString();
    }
}

