/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.apache.commons_3_5.lang3.concurrent;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import macromedia.externals.org.apache.commons_3_5.lang3.concurrent.AbstractCircuitBreaker;
import macromedia.externals.org.apache.commons_3_5.lang3.concurrent.CircuitBreakingException;
import macromedia.externals.org.apache.commons_3_5.lang3.concurrent.EventCountCircuitBreaker;

/*
 * Exception performing whole class analysis ignored.
 */
public class EventCountCircuitBreaker
extends AbstractCircuitBreaker<Integer> {
    private static final Map<AbstractCircuitBreaker.State, StateStrategy> STRATEGY_MAP = EventCountCircuitBreaker.createStrategyMap();
    private final AtomicReference<CheckIntervalData> checkIntervalData = new AtomicReference<CheckIntervalData>(new CheckIntervalData(0, 0L));
    private final int openingThreshold;
    private final long openingInterval;
    private final int closingThreshold;
    private final long closingInterval;

    public EventCountCircuitBreaker(int n2, long l2, TimeUnit timeUnit, int n3, long l3, TimeUnit timeUnit2) {
        this.openingThreshold = n2;
        this.openingInterval = timeUnit.toNanos(l2);
        this.closingThreshold = n3;
        this.closingInterval = timeUnit2.toNanos(l3);
    }

    public EventCountCircuitBreaker(int n2, long l2, TimeUnit timeUnit, int n3) {
        this(n2, l2, timeUnit, n3, l2, timeUnit);
    }

    public EventCountCircuitBreaker(int n2, long l2, TimeUnit timeUnit) {
        this(n2, l2, timeUnit, n2);
    }

    public int getOpeningThreshold() {
        return this.openingThreshold;
    }

    public long getOpeningInterval() {
        return this.openingInterval;
    }

    public int getClosingThreshold() {
        return this.closingThreshold;
    }

    public long getClosingInterval() {
        return this.closingInterval;
    }

    public boolean checkState() {
        return this.performStateCheck(0);
    }

    public boolean incrementAndCheckState(Integer n2) throws CircuitBreakingException {
        return this.performStateCheck(1);
    }

    public boolean incrementAndCheckState() {
        return this.incrementAndCheckState(Integer.valueOf(1));
    }

    public void open() {
        super.open();
        this.checkIntervalData.set(new CheckIntervalData(0, this.now()));
    }

    public void close() {
        super.close();
        this.checkIntervalData.set(new CheckIntervalData(0, this.now()));
    }

    private boolean performStateCheck(int n2) {
        long l2;
        AbstractCircuitBreaker.State state;
        CheckIntervalData checkIntervalData;
        CheckIntervalData checkIntervalData2;
        do {
            l2 = this.now();
            state = (AbstractCircuitBreaker.State)this.state.get();
        } while (!this.updateCheckIntervalData(checkIntervalData2 = (CheckIntervalData)this.checkIntervalData.get(), checkIntervalData = this.nextCheckIntervalData(n2, checkIntervalData2, state, l2)));
        if (EventCountCircuitBreaker.stateStrategy((AbstractCircuitBreaker.State)state).isStateTransition(this, checkIntervalData2, checkIntervalData)) {
            state = state.oppositeState();
            this.changeStateAndStartNewCheckInterval(state);
        }
        return !EventCountCircuitBreaker.isOpen((AbstractCircuitBreaker.State)state);
    }

    private boolean updateCheckIntervalData(CheckIntervalData checkIntervalData, CheckIntervalData checkIntervalData2) {
        return checkIntervalData == checkIntervalData2 || this.checkIntervalData.compareAndSet(checkIntervalData, checkIntervalData2);
    }

    private void changeStateAndStartNewCheckInterval(AbstractCircuitBreaker.State state) {
        this.changeState(state);
        this.checkIntervalData.set(new CheckIntervalData(0, this.now()));
    }

    private CheckIntervalData nextCheckIntervalData(int n2, CheckIntervalData checkIntervalData, AbstractCircuitBreaker.State state, long l2) {
        CheckIntervalData checkIntervalData2 = EventCountCircuitBreaker.stateStrategy((AbstractCircuitBreaker.State)state).isCheckIntervalFinished(this, checkIntervalData, l2) ? new CheckIntervalData(n2, l2) : checkIntervalData.increment(n2);
        return checkIntervalData2;
    }

    long now() {
        return System.nanoTime();
    }

    private static StateStrategy stateStrategy(AbstractCircuitBreaker.State state) {
        StateStrategy stateStrategy = (StateStrategy)STRATEGY_MAP.get(state);
        return stateStrategy;
    }

    private static Map<AbstractCircuitBreaker.State, StateStrategy> createStrategyMap() {
        EnumMap<AbstractCircuitBreaker.State, StateStrategy> enumMap = new EnumMap<AbstractCircuitBreaker.State, StateStrategy>(AbstractCircuitBreaker.State.class);
        enumMap.put(AbstractCircuitBreaker.State.CLOSED, (StateStrategy)new StateStrategyClosed(null));
        enumMap.put(AbstractCircuitBreaker.State.OPEN, (StateStrategy)new StateStrategyOpen(null));
        return enumMap;
    }
}

