/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.apache.commons_3_5.lang3.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import macromedia.externals.org.apache.commons_3_5.lang3.builder.Builder;
import macromedia.externals.org.apache.commons_3_5.lang3.builder.Diff;
import macromedia.externals.org.apache.commons_3_5.lang3.builder.DiffResult;
import macromedia.externals.org.apache.commons_3_5.lang3.builder.ToStringStyle;

public class DiffBuilder
implements Builder<DiffResult> {
    private final List<Diff<?>> diffs;
    private final boolean objectsTriviallyEqual;
    private final Object left;
    private final Object right;
    private final ToStringStyle style;

    public DiffBuilder(Object object, Object object2, ToStringStyle toStringStyle, boolean bl2) {
        if (object == null) {
            throw new IllegalArgumentException("lhs cannot be null");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("rhs cannot be null");
        }
        this.diffs = new ArrayList();
        this.left = object;
        this.right = object2;
        this.style = toStringStyle;
        this.objectsTriviallyEqual = bl2 && (object == object2 || object.equals(object2));
    }

    public DiffBuilder(Object object, Object object2, ToStringStyle toStringStyle) {
        this(object, object2, toStringStyle, true);
    }

    public DiffBuilder append(String string, boolean bl2, boolean bl3) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (bl2 != bl3) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String string, boolean[] blArray, boolean[] blArray2) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(blArray, blArray2)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String string, byte by2, byte by3) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (by2 != by3) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String string, byte[] byArray, byte[] byArray2) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(byArray, byArray2)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String string, char c2, char c3) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (c2 != c3) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String string, char[] cArray, char[] cArray2) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(cArray, cArray2)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String string, double d2, double d3) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (Double.doubleToLongBits(d2) != Double.doubleToLongBits(d3)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String string, double[] dArray, double[] dArray2) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(dArray, dArray2)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String string, float f2, float f3) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (Float.floatToIntBits(f2) != Float.floatToIntBits(f3)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String string, float[] fArray, float[] fArray2) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(fArray, fArray2)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String string, int n2, int n3) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (n2 != n3) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String string, int[] nArray, int[] nArray2) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(nArray, nArray2)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String string, long l2, long l3) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (l2 != l3) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String string, long[] lArray, long[] lArray2) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lArray, lArray2)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String string, short s2, short s3) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (s2 != s3) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String string, short[] sArray, short[] sArray2) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(sArray, sArray2)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String string, Object object, Object object2) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (object == object2) {
            return this;
        }
        Object object3 = object != null ? object : object2;
        if (object3.getClass().isArray()) {
            if (object3 instanceof boolean[]) {
                return this.append(string, (boolean[])object, (boolean[])object2);
            }
            if (object3 instanceof byte[]) {
                return this.append(string, (byte[])object, (byte[])object2);
            }
            if (object3 instanceof char[]) {
                return this.append(string, (char[])object, (char[])object2);
            }
            if (object3 instanceof double[]) {
                return this.append(string, (double[])object, (double[])object2);
            }
            if (object3 instanceof float[]) {
                return this.append(string, (float[])object, (float[])object2);
            }
            if (object3 instanceof int[]) {
                return this.append(string, (int[])object, (int[])object2);
            }
            if (object3 instanceof long[]) {
                return this.append(string, (long[])object, (long[])object2);
            }
            if (object3 instanceof short[]) {
                return this.append(string, (short[])object, (short[])object2);
            }
            return this.append(string, (Object[])object, (Object[])object2);
        }
        if (object != null && object.equals(object2)) {
            return this;
        }
        this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        return this;
    }

    public DiffBuilder append(String string, Object[] objectArray, Object[] objectArray2) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(objectArray, objectArray2)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String string, DiffResult diffResult) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (diffResult == null) {
            throw new IllegalArgumentException("Diff result cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        for (Diff diff : diffResult.getDiffs()) {
            this.append(string + "." + diff.getFieldName(), diff.getLeft(), diff.getRight());
        }
        return this;
    }

    public DiffResult build() {
        return new DiffResult(this.left, this.right, this.diffs, this.style);
    }
}

