/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.apache.commons_3_5.lang3;

import java.io.File;
import macromedia.externals.org.apache.commons_3_5.lang3.JavaVersion;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class SystemUtils {
    private static final String OS_NAME_WINDOWS_PREFIX = "Windows";
    private static final String USER_HOME_KEY = "user.home";
    private static final String USER_DIR_KEY = "user.dir";
    private static final String JAVA_IO_TMPDIR_KEY = "java.io.tmpdir";
    private static final String JAVA_HOME_KEY = "java.home";
    public static final String AWT_TOOLKIT = SystemUtils.getSystemProperty((String)"awt.toolkit");
    public static final String FILE_ENCODING = SystemUtils.getSystemProperty((String)"file.encoding");
    @Deprecated
    public static final String FILE_SEPARATOR = SystemUtils.getSystemProperty((String)"file.separator");
    public static final String JAVA_AWT_FONTS = SystemUtils.getSystemProperty((String)"java.awt.fonts");
    public static final String JAVA_AWT_GRAPHICSENV = SystemUtils.getSystemProperty((String)"java.awt.graphicsenv");
    public static final String JAVA_AWT_HEADLESS = SystemUtils.getSystemProperty((String)"java.awt.headless");
    public static final String JAVA_AWT_PRINTERJOB = SystemUtils.getSystemProperty((String)"java.awt.printerjob");
    public static final String JAVA_CLASS_PATH = SystemUtils.getSystemProperty((String)"java.class.path");
    public static final String JAVA_CLASS_VERSION = SystemUtils.getSystemProperty((String)"java.class.version");
    public static final String JAVA_COMPILER = SystemUtils.getSystemProperty((String)"java.compiler");
    public static final String JAVA_ENDORSED_DIRS = SystemUtils.getSystemProperty((String)"java.endorsed.dirs");
    public static final String JAVA_EXT_DIRS = SystemUtils.getSystemProperty((String)"java.ext.dirs");
    public static final String JAVA_HOME = SystemUtils.getSystemProperty((String)"java.home");
    public static final String JAVA_IO_TMPDIR = SystemUtils.getSystemProperty((String)"java.io.tmpdir");
    public static final String JAVA_LIBRARY_PATH = SystemUtils.getSystemProperty((String)"java.library.path");
    public static final String JAVA_RUNTIME_NAME = SystemUtils.getSystemProperty((String)"java.runtime.name");
    public static final String JAVA_RUNTIME_VERSION = SystemUtils.getSystemProperty((String)"java.runtime.version");
    public static final String JAVA_SPECIFICATION_NAME = SystemUtils.getSystemProperty((String)"java.specification.name");
    public static final String JAVA_SPECIFICATION_VENDOR = SystemUtils.getSystemProperty((String)"java.specification.vendor");
    public static final String JAVA_SPECIFICATION_VERSION = SystemUtils.getSystemProperty((String)"java.specification.version");
    private static final JavaVersion JAVA_SPECIFICATION_VERSION_AS_ENUM = JavaVersion.get((String)JAVA_SPECIFICATION_VERSION);
    public static final String JAVA_UTIL_PREFS_PREFERENCES_FACTORY = SystemUtils.getSystemProperty((String)"java.util.prefs.PreferencesFactory");
    public static final String JAVA_VENDOR = SystemUtils.getSystemProperty((String)"java.vendor");
    public static final String JAVA_VENDOR_URL = SystemUtils.getSystemProperty((String)"java.vendor.url");
    public static final String JAVA_VERSION = SystemUtils.getSystemProperty((String)"java.version");
    public static final String JAVA_VM_INFO = SystemUtils.getSystemProperty((String)"java.vm.info");
    public static final String JAVA_VM_NAME = SystemUtils.getSystemProperty((String)"java.vm.name");
    public static final String JAVA_VM_SPECIFICATION_NAME = SystemUtils.getSystemProperty((String)"java.vm.specification.name");
    public static final String JAVA_VM_SPECIFICATION_VENDOR = SystemUtils.getSystemProperty((String)"java.vm.specification.vendor");
    public static final String JAVA_VM_SPECIFICATION_VERSION = SystemUtils.getSystemProperty((String)"java.vm.specification.version");
    public static final String JAVA_VM_VENDOR = SystemUtils.getSystemProperty((String)"java.vm.vendor");
    public static final String JAVA_VM_VERSION = SystemUtils.getSystemProperty((String)"java.vm.version");
    public static final String LINE_SEPARATOR = SystemUtils.getSystemProperty((String)"line.separator");
    public static final String OS_ARCH = SystemUtils.getSystemProperty((String)"os.arch");
    public static final String OS_NAME = SystemUtils.getSystemProperty((String)"os.name");
    public static final String OS_VERSION = SystemUtils.getSystemProperty((String)"os.version");
    @Deprecated
    public static final String PATH_SEPARATOR = SystemUtils.getSystemProperty((String)"path.separator");
    public static final String USER_COUNTRY = SystemUtils.getSystemProperty((String)"user.country") == null ? SystemUtils.getSystemProperty((String)"user.region") : SystemUtils.getSystemProperty((String)"user.country");
    public static final String USER_DIR = SystemUtils.getSystemProperty((String)"user.dir");
    public static final String USER_HOME = SystemUtils.getSystemProperty((String)"user.home");
    public static final String USER_LANGUAGE = SystemUtils.getSystemProperty((String)"user.language");
    public static final String USER_NAME = SystemUtils.getSystemProperty((String)"user.name");
    public static final String USER_TIMEZONE = SystemUtils.getSystemProperty((String)"user.timezone");
    public static final boolean IS_JAVA_1_1 = SystemUtils.getJavaVersionMatches((String)"1.1");
    public static final boolean IS_JAVA_1_2 = SystemUtils.getJavaVersionMatches((String)"1.2");
    public static final boolean IS_JAVA_1_3 = SystemUtils.getJavaVersionMatches((String)"1.3");
    public static final boolean IS_JAVA_1_4 = SystemUtils.getJavaVersionMatches((String)"1.4");
    public static final boolean IS_JAVA_1_5 = SystemUtils.getJavaVersionMatches((String)"1.5");
    public static final boolean IS_JAVA_1_6 = SystemUtils.getJavaVersionMatches((String)"1.6");
    public static final boolean IS_JAVA_1_7 = SystemUtils.getJavaVersionMatches((String)"1.7");
    public static final boolean IS_JAVA_1_8 = SystemUtils.getJavaVersionMatches((String)"1.8");
    @Deprecated
    public static final boolean IS_JAVA_1_9 = SystemUtils.getJavaVersionMatches((String)"9");
    public static final boolean IS_JAVA_9 = SystemUtils.getJavaVersionMatches((String)"9");
    public static final boolean IS_OS_AIX = SystemUtils.getOSMatchesName((String)"AIX");
    public static final boolean IS_OS_HP_UX = SystemUtils.getOSMatchesName((String)"HP-UX");
    public static final boolean IS_OS_400 = SystemUtils.getOSMatchesName((String)"OS/400");
    public static final boolean IS_OS_IRIX = SystemUtils.getOSMatchesName((String)"Irix");
    public static final boolean IS_OS_LINUX = SystemUtils.getOSMatchesName((String)"Linux") || SystemUtils.getOSMatchesName((String)"LINUX");
    public static final boolean IS_OS_MAC = SystemUtils.getOSMatchesName((String)"Mac");
    public static final boolean IS_OS_MAC_OSX = SystemUtils.getOSMatchesName((String)"Mac OS X");
    public static final boolean IS_OS_MAC_OSX_CHEETAH = SystemUtils.getOSMatches((String)"Mac OS X", (String)"10.0");
    public static final boolean IS_OS_MAC_OSX_PUMA = SystemUtils.getOSMatches((String)"Mac OS X", (String)"10.1");
    public static final boolean IS_OS_MAC_OSX_JAGUAR = SystemUtils.getOSMatches((String)"Mac OS X", (String)"10.2");
    public static final boolean IS_OS_MAC_OSX_PANTHER = SystemUtils.getOSMatches((String)"Mac OS X", (String)"10.3");
    public static final boolean IS_OS_MAC_OSX_TIGER = SystemUtils.getOSMatches((String)"Mac OS X", (String)"10.4");
    public static final boolean IS_OS_MAC_OSX_LEOPARD = SystemUtils.getOSMatches((String)"Mac OS X", (String)"10.5");
    public static final boolean IS_OS_MAC_OSX_SNOW_LEOPARD = SystemUtils.getOSMatches((String)"Mac OS X", (String)"10.6");
    public static final boolean IS_OS_MAC_OSX_LION = SystemUtils.getOSMatches((String)"Mac OS X", (String)"10.7");
    public static final boolean IS_OS_MAC_OSX_MOUNTAIN_LION = SystemUtils.getOSMatches((String)"Mac OS X", (String)"10.8");
    public static final boolean IS_OS_MAC_OSX_MAVERICKS = SystemUtils.getOSMatches((String)"Mac OS X", (String)"10.9");
    public static final boolean IS_OS_MAC_OSX_YOSEMITE = SystemUtils.getOSMatches((String)"Mac OS X", (String)"10.10");
    public static final boolean IS_OS_MAC_OSX_EL_CAPITAN = SystemUtils.getOSMatches((String)"Mac OS X", (String)"10.11");
    public static final boolean IS_OS_FREE_BSD = SystemUtils.getOSMatchesName((String)"FreeBSD");
    public static final boolean IS_OS_OPEN_BSD = SystemUtils.getOSMatchesName((String)"OpenBSD");
    public static final boolean IS_OS_NET_BSD = SystemUtils.getOSMatchesName((String)"NetBSD");
    public static final boolean IS_OS_OS2 = SystemUtils.getOSMatchesName((String)"OS/2");
    public static final boolean IS_OS_SOLARIS = SystemUtils.getOSMatchesName((String)"Solaris");
    public static final boolean IS_OS_SUN_OS = SystemUtils.getOSMatchesName((String)"SunOS");
    public static final boolean IS_OS_UNIX = IS_OS_AIX || IS_OS_HP_UX || IS_OS_IRIX || IS_OS_LINUX || IS_OS_MAC_OSX || IS_OS_SOLARIS || IS_OS_SUN_OS || IS_OS_FREE_BSD || IS_OS_OPEN_BSD || IS_OS_NET_BSD;
    public static final boolean IS_OS_WINDOWS = SystemUtils.getOSMatchesName((String)"Windows");
    public static final boolean IS_OS_WINDOWS_2000 = SystemUtils.getOSMatchesName((String)"Windows 2000");
    public static final boolean IS_OS_WINDOWS_2003 = SystemUtils.getOSMatchesName((String)"Windows 2003");
    public static final boolean IS_OS_WINDOWS_2008 = SystemUtils.getOSMatchesName((String)"Windows Server 2008");
    public static final boolean IS_OS_WINDOWS_2012 = SystemUtils.getOSMatchesName((String)"Windows Server 2012");
    public static final boolean IS_OS_WINDOWS_95 = SystemUtils.getOSMatchesName((String)"Windows 95");
    public static final boolean IS_OS_WINDOWS_98 = SystemUtils.getOSMatchesName((String)"Windows 98");
    public static final boolean IS_OS_WINDOWS_ME = SystemUtils.getOSMatchesName((String)"Windows Me");
    public static final boolean IS_OS_WINDOWS_NT = SystemUtils.getOSMatchesName((String)"Windows NT");
    public static final boolean IS_OS_WINDOWS_XP = SystemUtils.getOSMatchesName((String)"Windows XP");
    public static final boolean IS_OS_WINDOWS_VISTA = SystemUtils.getOSMatchesName((String)"Windows Vista");
    public static final boolean IS_OS_WINDOWS_7 = SystemUtils.getOSMatchesName((String)"Windows 7");
    public static final boolean IS_OS_WINDOWS_8 = SystemUtils.getOSMatchesName((String)"Windows 8");
    public static final boolean IS_OS_WINDOWS_10 = SystemUtils.getOSMatchesName((String)"Windows 10");
    public static final boolean IS_OS_ZOS = SystemUtils.getOSMatchesName((String)"z/OS");

    public static File getJavaHome() {
        return new File(System.getProperty("java.home"));
    }

    public static File getJavaIoTmpDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    private static boolean getJavaVersionMatches(String string) {
        return SystemUtils.isJavaVersionMatch((String)JAVA_SPECIFICATION_VERSION, (String)string);
    }

    private static boolean getOSMatches(String string, String string2) {
        return SystemUtils.isOSMatch((String)OS_NAME, (String)OS_VERSION, (String)string, (String)string2);
    }

    private static boolean getOSMatchesName(String string) {
        return SystemUtils.isOSNameMatch((String)OS_NAME, (String)string);
    }

    private static String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            System.err.println("Caught a SecurityException reading the system property '" + string + "'; the SystemUtils property value will default to null.");
            return null;
        }
    }

    public static File getUserDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static File getUserHome() {
        return new File(System.getProperty("user.home"));
    }

    public static boolean isJavaAwtHeadless() {
        return Boolean.TRUE.toString().equals(JAVA_AWT_HEADLESS);
    }

    public static boolean isJavaVersionAtLeast(JavaVersion javaVersion) {
        return JAVA_SPECIFICATION_VERSION_AS_ENUM.atLeast(javaVersion);
    }

    static boolean isJavaVersionMatch(String string, String string2) {
        if (string == null) {
            return false;
        }
        return string.startsWith(string2);
    }

    static boolean isOSMatch(String string, String string2, String string3, String string4) {
        if (string == null || string2 == null) {
            return false;
        }
        return SystemUtils.isOSNameMatch((String)string, (String)string3) && SystemUtils.isOSVersionMatch((String)string2, (String)string4);
    }

    static boolean isOSNameMatch(String string, String string2) {
        if (string == null) {
            return false;
        }
        return string.startsWith(string2);
    }

    static boolean isOSVersionMatch(String string, String string2) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        String[] stringArray = string2.split("\\.");
        String[] stringArray2 = string.split("\\.");
        for (int i2 = 0; i2 < Math.min(stringArray.length, stringArray2.length); ++i2) {
            if (stringArray[i2].equals(stringArray2[i2])) continue;
            return false;
        }
        return true;
    }
}

