/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.apache.commons_1_10.codec.net;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import macromedia.externals.org.apache.commons_1_10.codec.Charsets;
import macromedia.externals.org.apache.commons_1_10.codec.DecoderException;
import macromedia.externals.org.apache.commons_1_10.codec.EncoderException;
import macromedia.externals.org.apache.commons_1_10.codec.StringDecoder;
import macromedia.externals.org.apache.commons_1_10.codec.StringEncoder;
import macromedia.externals.org.apache.commons_1_10.codec.binary.Base64;
import macromedia.externals.org.apache.commons_1_10.codec.net.RFC1522Codec;

public class BCodec
extends RFC1522Codec
implements StringDecoder,
StringEncoder {
    private final Charset charset;

    public BCodec() {
        this(Charsets.UTF_8);
    }

    public BCodec(Charset charset) {
        this.charset = charset;
    }

    public BCodec(String string) {
        this(Charset.forName(string));
    }

    protected String getEncoding() {
        return "B";
    }

    protected byte[] doEncoding(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return Base64.encodeBase64((byte[])byArray);
    }

    protected byte[] doDecoding(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return Base64.decodeBase64((byte[])byArray);
    }

    public String encode(String string, Charset charset) throws EncoderException {
        if (string == null) {
            return null;
        }
        return this.encodeText(string, charset);
    }

    public String encode(String string, String string2) throws EncoderException {
        if (string == null) {
            return null;
        }
        try {
            return this.encodeText(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EncoderException(unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
        }
    }

    public String encode(String string) throws EncoderException {
        if (string == null) {
            return null;
        }
        return this.encode(string, this.getCharset());
    }

    public String decode(String string) throws DecoderException {
        if (string == null) {
            return null;
        }
        try {
            return this.decodeText(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DecoderException(unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
        }
    }

    public Object encode(Object object) throws EncoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return this.encode((String)object);
        }
        throw new EncoderException("Objects of type " + object.getClass().getName() + " cannot be encoded using BCodec");
    }

    public Object decode(Object object) throws DecoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return this.decode((String)object);
        }
        throw new DecoderException("Objects of type " + object.getClass().getName() + " cannot be decoded using BCodec");
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getDefaultCharset() {
        return this.charset.name();
    }
}

