/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.net.minidev.json_1_3_1.parser;

import java.io.InputStream;
import java.io.Reader;
import macromedia.externals.net.minidev.json_1_3_1.parser.ContainerFactory;
import macromedia.externals.net.minidev.json_1_3_1.parser.ContentHandler;
import macromedia.externals.net.minidev.json_1_3_1.parser.ContentHandlerDumy;
import macromedia.externals.net.minidev.json_1_3_1.parser.JSONParserByteArray;
import macromedia.externals.net.minidev.json_1_3_1.parser.JSONParserInputStream;
import macromedia.externals.net.minidev.json_1_3_1.parser.JSONParserReader;
import macromedia.externals.net.minidev.json_1_3_1.parser.JSONParserString;
import macromedia.externals.net.minidev.json_1_3_1.parser.ParseException;

public class JSONParser {
    public static final int ACCEPT_SIMPLE_QUOTE = 1;
    public static final int ACCEPT_NON_QUOTE = 2;
    public static final int ACCEPT_NAN = 4;
    public static final int IGNORE_CONTROL_CHAR = 8;
    public static final int USE_INTEGER_STORAGE = 16;
    public static final int ACCEPT_LEADING_ZERO = 32;
    public static final int ACCEPT_USELESS_COMMA = 64;
    public static final int USE_HI_PRECISION_FLOAT = 128;
    public static final int ACCEPT_TAILLING_DATA = 256;
    public static final int ACCEPT_TAILLING_SPACE = 512;
    public static final int MODE_PERMISSIVE = -1;
    public static final int MODE_RFC4627 = 400;
    public static final int MODE_JSON_SIMPLE = 960;
    public static final int MODE_STRICTEST = 144;
    public static int DEFAULT_PERMISSIVE_MODE = System.getProperty("JSON_SMART_SIMPLE") != null ? 960 : -1;
    private int mode;
    private JSONParserReader pStream;
    private JSONParserInputStream pSBintream;
    private JSONParserString pString;
    private JSONParserByteArray pBytes;

    public JSONParser() {
        this.mode = DEFAULT_PERMISSIVE_MODE;
    }

    public JSONParser(int n2) {
        this.mode = n2;
    }

    public Object parse(String string) throws ParseException {
        if (this.pString == null) {
            this.pString = new JSONParserString(this.mode);
        }
        return this.pString.parse(string);
    }

    public Object parse(String string, ContainerFactory containerFactory) throws ParseException {
        if (this.pString == null) {
            this.pString = new JSONParserString(this.mode);
        }
        return this.pString.parse(string, containerFactory);
    }

    public Object parse(String string, ContainerFactory containerFactory, ContentHandler contentHandler) throws ParseException {
        if (this.pString == null) {
            this.pString = new JSONParserString(this.mode);
        }
        return this.pString.parse(string, containerFactory, contentHandler);
    }

    public Object parse(byte[] byArray) throws ParseException {
        if (this.pBytes == null) {
            this.pBytes = new JSONParserByteArray(this.mode);
        }
        return this.pBytes.parse(byArray);
    }

    public Object parse(byte[] byArray, ContainerFactory containerFactory) throws ParseException {
        if (this.pBytes == null) {
            this.pBytes = new JSONParserByteArray(this.mode);
        }
        return this.pBytes.parse(byArray, containerFactory);
    }

    public Object parse(byte[] byArray, ContainerFactory containerFactory, ContentHandler contentHandler) throws ParseException {
        if (this.pBytes == null) {
            this.pBytes = new JSONParserByteArray(this.mode);
        }
        return this.pBytes.parse(byArray, containerFactory, contentHandler);
    }

    public Object parse(byte[] byArray, int n2, int n3) throws ParseException {
        if (this.pBytes == null) {
            this.pBytes = new JSONParserByteArray(this.mode);
        }
        return this.pBytes.parse(byArray, n2, n3, ContainerFactory.FACTORY_SIMPLE, (ContentHandler)ContentHandlerDumy.HANDLER);
    }

    public Object parse(byte[] byArray, int n2, int n3, ContainerFactory containerFactory) throws ParseException {
        if (this.pBytes == null) {
            this.pBytes = new JSONParserByteArray(this.mode);
        }
        return this.pBytes.parse(byArray, n2, n3, containerFactory, (ContentHandler)ContentHandlerDumy.HANDLER);
    }

    public Object parse(byte[] byArray, int n2, int n3, ContainerFactory containerFactory, ContentHandler contentHandler) throws ParseException {
        if (this.pBytes == null) {
            this.pBytes = new JSONParserByteArray(this.mode);
        }
        return this.pBytes.parse(byArray, n2, n3, containerFactory, contentHandler);
    }

    public Object parse(Reader reader) throws ParseException {
        if (this.pStream == null) {
            this.pStream = new JSONParserReader(this.mode);
        }
        return this.pStream.parse(reader);
    }

    public Object parse(Reader reader, ContainerFactory containerFactory) throws ParseException {
        if (this.pStream == null) {
            this.pStream = new JSONParserReader(this.mode);
        }
        return this.pStream.parse(reader, containerFactory);
    }

    public Object parse(Reader reader, ContainerFactory containerFactory, ContentHandler contentHandler) throws ParseException {
        if (this.pStream == null) {
            this.pStream = new JSONParserReader(this.mode);
        }
        return this.pStream.parse(reader, containerFactory, contentHandler);
    }

    public Object parse(InputStream inputStream) throws ParseException {
        if (this.pSBintream == null) {
            this.pSBintream = new JSONParserInputStream(this.mode);
        }
        return this.pSBintream.parse(inputStream);
    }

    public Object parse(InputStream inputStream, ContainerFactory containerFactory) throws ParseException {
        if (this.pSBintream == null) {
            this.pSBintream = new JSONParserInputStream(this.mode);
        }
        return this.pSBintream.parse(inputStream, containerFactory);
    }

    public Object parse(InputStream inputStream, ContainerFactory containerFactory, ContentHandler contentHandler) throws ParseException {
        if (this.pSBintream == null) {
            this.pSBintream = new JSONParserInputStream(this.mode);
        }
        return this.pSBintream.parse(inputStream, containerFactory, contentHandler);
    }
}

