/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.javax.mail_1_4_7.internet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownServiceException;
import javax.activation.DataSource;
import macromedia.externals.com.sun.mail_1_4_7.util.FolderClosedIOException;
import macromedia.externals.javax.mail_1_4_7.FolderClosedException;
import macromedia.externals.javax.mail_1_4_7.MessageAware;
import macromedia.externals.javax.mail_1_4_7.MessageContext;
import macromedia.externals.javax.mail_1_4_7.MessagingException;
import macromedia.externals.javax.mail_1_4_7.Part;
import macromedia.externals.javax.mail_1_4_7.internet.MimeBodyPart;
import macromedia.externals.javax.mail_1_4_7.internet.MimeMessage;
import macromedia.externals.javax.mail_1_4_7.internet.MimePart;
import macromedia.externals.javax.mail_1_4_7.internet.MimeUtility;

public class MimePartDataSource
implements MessageAware,
DataSource {
    protected MimePart part;
    private MessageContext context;

    public MimePartDataSource(MimePart mimePart) {
        this.part = mimePart;
    }

    public InputStream getInputStream() throws IOException {
        try {
            InputStream inputStream;
            if (this.part instanceof MimeBodyPart) {
                inputStream = ((MimeBodyPart)this.part).getContentStream();
            } else if (this.part instanceof MimeMessage) {
                inputStream = ((MimeMessage)this.part).getContentStream();
            } else {
                throw new MessagingException("Unknown part");
            }
            String string = MimeBodyPart.restrictEncoding((MimePart)this.part, (String)this.part.getEncoding());
            if (string != null) {
                return MimeUtility.decode((InputStream)inputStream, (String)string);
            }
            return inputStream;
        }
        catch (FolderClosedException folderClosedException) {
            throw new FolderClosedIOException(folderClosedException.getFolder(), folderClosedException.getMessage());
        }
        catch (MessagingException messagingException) {
            throw new IOException(messagingException.getMessage());
        }
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException("Writing not supported");
    }

    public String getContentType() {
        try {
            return this.part.getContentType();
        }
        catch (MessagingException messagingException) {
            return "application/octet-stream";
        }
    }

    public String getName() {
        try {
            if (this.part instanceof MimeBodyPart) {
                return ((MimeBodyPart)this.part).getFileName();
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return "";
    }

    public synchronized MessageContext getMessageContext() {
        if (this.context == null) {
            this.context = new MessageContext((Part)this.part);
        }
        return this.context;
    }
}

