/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.javax.mail_1_4_7.internet;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import macromedia.externals.com.sun.mail_1_4_7.util.ASCIIUtility;
import macromedia.externals.com.sun.mail_1_4_7.util.FolderClosedIOException;
import macromedia.externals.com.sun.mail_1_4_7.util.LineOutputStream;
import macromedia.externals.com.sun.mail_1_4_7.util.MessageRemovedIOException;
import macromedia.externals.com.sun.mail_1_4_7.util.MimeUtil;
import macromedia.externals.com.sun.mail_1_4_7.util.PropUtil;
import macromedia.externals.javax.mail_1_4_7.Address;
import macromedia.externals.javax.mail_1_4_7.Flags;
import macromedia.externals.javax.mail_1_4_7.Folder;
import macromedia.externals.javax.mail_1_4_7.FolderClosedException;
import macromedia.externals.javax.mail_1_4_7.Message;
import macromedia.externals.javax.mail_1_4_7.MessageRemovedException;
import macromedia.externals.javax.mail_1_4_7.MessagingException;
import macromedia.externals.javax.mail_1_4_7.Multipart;
import macromedia.externals.javax.mail_1_4_7.Part;
import macromedia.externals.javax.mail_1_4_7.Session;
import macromedia.externals.javax.mail_1_4_7.internet.InternetAddress;
import macromedia.externals.javax.mail_1_4_7.internet.InternetHeaders;
import macromedia.externals.javax.mail_1_4_7.internet.MailDateFormat;
import macromedia.externals.javax.mail_1_4_7.internet.MimeBodyPart;
import macromedia.externals.javax.mail_1_4_7.internet.MimeMessage;
import macromedia.externals.javax.mail_1_4_7.internet.MimeMultipart;
import macromedia.externals.javax.mail_1_4_7.internet.MimePart;
import macromedia.externals.javax.mail_1_4_7.internet.MimePartDataSource;
import macromedia.externals.javax.mail_1_4_7.internet.MimeUtility;
import macromedia.externals.javax.mail_1_4_7.internet.NewsAddress;
import macromedia.externals.javax.mail_1_4_7.internet.SharedInputStream;
import macromedia.externals.javax.mail_1_4_7.internet.UniqueValue;
import macromedia.externals.javax.mail_1_4_7.util.SharedByteArrayInputStream;

public class MimeMessage
extends Message
implements MimePart {
    protected DataHandler dh;
    protected byte[] content;
    protected InputStream contentStream;
    protected InternetHeaders headers;
    protected Flags flags;
    protected boolean modified = false;
    protected boolean saved = false;
    Object cachedContent;
    private static final MailDateFormat mailDateFormat = new MailDateFormat();
    private boolean strict = true;
    private static final Flags answeredFlag = new Flags(Flags.Flag.ANSWERED);

    public MimeMessage(Session session) {
        super(session);
        this.modified = true;
        this.headers = new InternetHeaders();
        this.flags = new Flags();
        this.initStrict();
    }

    public MimeMessage(Session session, InputStream inputStream) throws MessagingException {
        super(session);
        this.flags = new Flags();
        this.initStrict();
        this.parse(inputStream);
        this.saved = true;
    }

    public MimeMessage(MimeMessage mimeMessage) throws MessagingException {
        super(mimeMessage.session);
        int n2;
        this.flags = mimeMessage.getFlags();
        if (this.flags == null) {
            this.flags = new Flags();
        }
        ByteArrayOutputStream byteArrayOutputStream = (n2 = mimeMessage.getSize()) > 0 ? new ByteArrayOutputStream(n2) : new ByteArrayOutputStream();
        try {
            this.strict = mimeMessage.strict;
            mimeMessage.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            SharedByteArrayInputStream sharedByteArrayInputStream = new SharedByteArrayInputStream(byteArrayOutputStream.toByteArray());
            this.parse((InputStream)sharedByteArrayInputStream);
            sharedByteArrayInputStream.close();
            this.saved = true;
        }
        catch (IOException iOException) {
            throw new MessagingException("IOException while copying message", (Exception)iOException);
        }
    }

    protected MimeMessage(Folder folder, int n2) {
        super(folder, n2);
        this.flags = new Flags();
        this.saved = true;
        this.initStrict();
    }

    protected MimeMessage(Folder folder, InputStream inputStream, int n2) throws MessagingException {
        this(folder, n2);
        this.initStrict();
        this.parse(inputStream);
    }

    protected MimeMessage(Folder folder, InternetHeaders internetHeaders, byte[] byArray, int n2) throws MessagingException {
        this(folder, n2);
        this.headers = internetHeaders;
        this.content = byArray;
        this.initStrict();
    }

    private void initStrict() {
        if (this.session != null) {
            this.strict = PropUtil.getBooleanSessionProperty((Session)this.session, (String)"mail.mime.address.strict", (boolean)true);
        }
    }

    protected void parse(InputStream inputStream) throws MessagingException {
        if (!(inputStream instanceof ByteArrayInputStream || inputStream instanceof BufferedInputStream || inputStream instanceof SharedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.headers = this.createInternetHeaders(inputStream);
        if (inputStream instanceof SharedInputStream) {
            SharedInputStream sharedInputStream = (SharedInputStream)inputStream;
            this.contentStream = sharedInputStream.newStream(sharedInputStream.getPosition(), -1L);
        } else {
            try {
                this.content = ASCIIUtility.getBytes((InputStream)inputStream);
            }
            catch (IOException iOException) {
                throw new MessagingException("IOException", (Exception)iOException);
            }
        }
        this.modified = false;
    }

    public Address[] getFrom() throws MessagingException {
        Address[] addressArray = this.getAddressHeader("From");
        if (addressArray == null) {
            addressArray = this.getAddressHeader("Sender");
        }
        return addressArray;
    }

    public void setFrom(Address address) throws MessagingException {
        if (address == null) {
            this.removeHeader("From");
        } else {
            this.setHeader("From", address.toString());
        }
    }

    public void setFrom() throws MessagingException {
        InternetAddress internetAddress = null;
        try {
            internetAddress = InternetAddress._getLocalAddress((Session)this.session);
        }
        catch (Exception exception) {
            throw new MessagingException("No From address", exception);
        }
        if (internetAddress == null) {
            throw new MessagingException("No From address");
        }
        this.setFrom((Address)internetAddress);
    }

    public void addFrom(Address[] addressArray) throws MessagingException {
        this.addAddressHeader("From", addressArray);
    }

    public Address getSender() throws MessagingException {
        Address[] addressArray = this.getAddressHeader("Sender");
        if (addressArray == null || addressArray.length == 0) {
            return null;
        }
        return addressArray[0];
    }

    public void setSender(Address address) throws MessagingException {
        if (address == null) {
            this.removeHeader("Sender");
        } else {
            this.setHeader("Sender", address.toString());
        }
    }

    public Address[] getRecipients(Message.RecipientType recipientType) throws MessagingException {
        if (recipientType == RecipientType.NEWSGROUPS) {
            String string = this.getHeader("Newsgroups", ",");
            return string == null ? null : NewsAddress.parse((String)string);
        }
        return this.getAddressHeader(this.getHeaderName(recipientType));
    }

    public Address[] getAllRecipients() throws MessagingException {
        Address[] addressArray = super.getAllRecipients();
        Address[] addressArray2 = this.getRecipients((Message.RecipientType)RecipientType.NEWSGROUPS);
        if (addressArray2 == null) {
            return addressArray;
        }
        if (addressArray == null) {
            return addressArray2;
        }
        Address[] addressArray3 = new Address[addressArray.length + addressArray2.length];
        System.arraycopy(addressArray, 0, addressArray3, 0, addressArray.length);
        System.arraycopy(addressArray2, 0, addressArray3, addressArray.length, addressArray2.length);
        return addressArray3;
    }

    public void setRecipients(Message.RecipientType recipientType, Address[] addressArray) throws MessagingException {
        if (recipientType == RecipientType.NEWSGROUPS) {
            if (addressArray == null || addressArray.length == 0) {
                this.removeHeader("Newsgroups");
            } else {
                this.setHeader("Newsgroups", NewsAddress.toString((Address[])addressArray));
            }
        } else {
            this.setAddressHeader(this.getHeaderName(recipientType), addressArray);
        }
    }

    public void setRecipients(Message.RecipientType recipientType, String string) throws MessagingException {
        if (recipientType == RecipientType.NEWSGROUPS) {
            if (string == null || string.length() == 0) {
                this.removeHeader("Newsgroups");
            } else {
                this.setHeader("Newsgroups", string);
            }
        } else {
            this.setAddressHeader(this.getHeaderName(recipientType), (Address[])(string == null ? null : InternetAddress.parse((String)string)));
        }
    }

    public void addRecipients(Message.RecipientType recipientType, Address[] addressArray) throws MessagingException {
        if (recipientType == RecipientType.NEWSGROUPS) {
            String string = NewsAddress.toString((Address[])addressArray);
            if (string != null) {
                this.addHeader("Newsgroups", string);
            }
        } else {
            this.addAddressHeader(this.getHeaderName(recipientType), addressArray);
        }
    }

    public void addRecipients(Message.RecipientType recipientType, String string) throws MessagingException {
        if (recipientType == RecipientType.NEWSGROUPS) {
            if (string != null && string.length() != 0) {
                this.addHeader("Newsgroups", string);
            }
        } else {
            this.addAddressHeader(this.getHeaderName(recipientType), (Address[])InternetAddress.parse((String)string));
        }
    }

    public Address[] getReplyTo() throws MessagingException {
        Address[] addressArray = this.getAddressHeader("Reply-To");
        if (addressArray == null || addressArray.length == 0) {
            addressArray = this.getFrom();
        }
        return addressArray;
    }

    public void setReplyTo(Address[] addressArray) throws MessagingException {
        this.setAddressHeader("Reply-To", addressArray);
    }

    private Address[] getAddressHeader(String string) throws MessagingException {
        String string2 = this.getHeader(string, ",");
        return string2 == null ? null : InternetAddress.parseHeader((String)string2, (boolean)this.strict);
    }

    private void setAddressHeader(String string, Address[] addressArray) throws MessagingException {
        String string2 = InternetAddress.toString((Address[])addressArray);
        if (string2 == null) {
            this.removeHeader(string);
        } else {
            this.setHeader(string, string2);
        }
    }

    private void addAddressHeader(String string, Address[] addressArray) throws MessagingException {
        Address[] addressArray2;
        if (addressArray == null || addressArray.length == 0) {
            return;
        }
        Address[] addressArray3 = this.getAddressHeader(string);
        if (addressArray3 == null || addressArray3.length == 0) {
            addressArray2 = addressArray;
        } else {
            addressArray2 = new Address[addressArray3.length + addressArray.length];
            System.arraycopy(addressArray3, 0, addressArray2, 0, addressArray3.length);
            System.arraycopy(addressArray, 0, addressArray2, addressArray3.length, addressArray.length);
        }
        String string2 = InternetAddress.toString((Address[])addressArray2);
        if (string2 == null) {
            return;
        }
        this.setHeader(string, string2);
    }

    public String getSubject() throws MessagingException {
        String string = this.getHeader("Subject", null);
        if (string == null) {
            return null;
        }
        try {
            return MimeUtility.decodeText((String)MimeUtility.unfold((String)string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public void setSubject(String string) throws MessagingException {
        this.setSubject(string, null);
    }

    public void setSubject(String string, String string2) throws MessagingException {
        if (string == null) {
            this.removeHeader("Subject");
        } else {
            try {
                this.setHeader("Subject", MimeUtility.fold((int)9, (String)MimeUtility.encodeText((String)string, (String)string2, null)));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new MessagingException("Encoding error", (Exception)unsupportedEncodingException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getSentDate() throws MessagingException {
        String string = this.getHeader("Date", null);
        if (string != null) {
            try {
                MailDateFormat mailDateFormat = MimeMessage.mailDateFormat;
                synchronized (mailDateFormat) {
                    return MimeMessage.mailDateFormat.parse(string);
                }
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSentDate(Date date) throws MessagingException {
        if (date == null) {
            this.removeHeader("Date");
        } else {
            MailDateFormat mailDateFormat = MimeMessage.mailDateFormat;
            synchronized (mailDateFormat) {
                this.setHeader("Date", MimeMessage.mailDateFormat.format(date));
            }
        }
    }

    public Date getReceivedDate() throws MessagingException {
        return null;
    }

    public int getSize() throws MessagingException {
        if (this.content != null) {
            return this.content.length;
        }
        if (this.contentStream != null) {
            try {
                int n2 = this.contentStream.available();
                if (n2 > 0) {
                    return n2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getLineCount() throws MessagingException {
        return -1;
    }

    public String getContentType() throws MessagingException {
        String string = this.getHeader("Content-Type", null);
        if ((string = MimeUtil.cleanContentType((MimePart)this, (String)string)) == null) {
            return "text/plain";
        }
        return string;
    }

    public boolean isMimeType(String string) throws MessagingException {
        return MimeBodyPart.isMimeType((MimePart)this, (String)string);
    }

    public String getDisposition() throws MessagingException {
        return MimeBodyPart.getDisposition((MimePart)this);
    }

    public void setDisposition(String string) throws MessagingException {
        MimeBodyPart.setDisposition((MimePart)this, (String)string);
    }

    public String getEncoding() throws MessagingException {
        return MimeBodyPart.getEncoding((MimePart)this);
    }

    public String getContentID() throws MessagingException {
        return this.getHeader("Content-Id", null);
    }

    public void setContentID(String string) throws MessagingException {
        if (string == null) {
            this.removeHeader("Content-ID");
        } else {
            this.setHeader("Content-ID", string);
        }
    }

    public String getContentMD5() throws MessagingException {
        return this.getHeader("Content-MD5", null);
    }

    public void setContentMD5(String string) throws MessagingException {
        this.setHeader("Content-MD5", string);
    }

    public String getDescription() throws MessagingException {
        return MimeBodyPart.getDescription((MimePart)this);
    }

    public void setDescription(String string) throws MessagingException {
        this.setDescription(string, null);
    }

    public void setDescription(String string, String string2) throws MessagingException {
        MimeBodyPart.setDescription((MimePart)this, (String)string, (String)string2);
    }

    public String[] getContentLanguage() throws MessagingException {
        return MimeBodyPart.getContentLanguage((MimePart)this);
    }

    public void setContentLanguage(String[] stringArray) throws MessagingException {
        MimeBodyPart.setContentLanguage((MimePart)this, (String[])stringArray);
    }

    public String getMessageID() throws MessagingException {
        return this.getHeader("Message-ID", null);
    }

    public String getFileName() throws MessagingException {
        return MimeBodyPart.getFileName((MimePart)this);
    }

    public void setFileName(String string) throws MessagingException {
        MimeBodyPart.setFileName((MimePart)this, (String)string);
    }

    private String getHeaderName(Message.RecipientType recipientType) throws MessagingException {
        String string;
        if (recipientType == Message.RecipientType.TO) {
            string = "To";
        } else if (recipientType == Message.RecipientType.CC) {
            string = "Cc";
        } else if (recipientType == Message.RecipientType.BCC) {
            string = "Bcc";
        } else if (recipientType == RecipientType.NEWSGROUPS) {
            string = "Newsgroups";
        } else {
            throw new MessagingException("Invalid Recipient Type");
        }
        return string;
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        return this.getDataHandler().getInputStream();
    }

    protected InputStream getContentStream() throws MessagingException {
        if (this.contentStream != null) {
            return ((SharedInputStream)this.contentStream).newStream(0L, -1L);
        }
        if (this.content != null) {
            return new SharedByteArrayInputStream(this.content);
        }
        throw new MessagingException("No MimeMessage content");
    }

    public InputStream getRawInputStream() throws MessagingException {
        return this.getContentStream();
    }

    public synchronized DataHandler getDataHandler() throws MessagingException {
        if (this.dh == null) {
            this.dh = new MimeBodyPart.MimePartDataHandler((DataSource)new MimePartDataSource((MimePart)this));
        }
        return this.dh;
    }

    public Object getContent() throws IOException, MessagingException {
        Object object;
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        try {
            object = this.getDataHandler().getContent();
        }
        catch (FolderClosedIOException folderClosedIOException) {
            throw new FolderClosedException(folderClosedIOException.getFolder(), folderClosedIOException.getMessage());
        }
        catch (MessageRemovedIOException messageRemovedIOException) {
            throw new MessageRemovedException(messageRemovedIOException.getMessage());
        }
        if (MimeBodyPart.cacheMultipart && (object instanceof Multipart || object instanceof Message) && (this.content != null || this.contentStream != null)) {
            this.cachedContent = object;
            if (object instanceof MimeMultipart) {
                ((MimeMultipart)object).parse();
            }
        }
        return object;
    }

    public synchronized void setDataHandler(DataHandler dataHandler) throws MessagingException {
        this.dh = dataHandler;
        this.cachedContent = null;
        MimeBodyPart.invalidateContentHeaders((MimePart)this);
    }

    public void setContent(Object object, String string) throws MessagingException {
        if (object instanceof Multipart) {
            this.setContent((Multipart)object);
        } else {
            this.setDataHandler(new DataHandler(object, string));
        }
    }

    public void setText(String string) throws MessagingException {
        this.setText(string, null);
    }

    public void setText(String string, String string2) throws MessagingException {
        MimeBodyPart.setText((MimePart)this, (String)string, (String)string2, (String)"plain");
    }

    public void setText(String string, String string2, String string3) throws MessagingException {
        MimeBodyPart.setText((MimePart)this, (String)string, (String)string2, (String)string3);
    }

    public void setContent(Multipart multipart) throws MessagingException {
        this.setDataHandler(new DataHandler((Object)multipart, multipart.getContentType()));
        multipart.setParent((Part)this);
    }

    public Message reply(boolean bl2) throws MessagingException {
        Object object;
        Object object2;
        MimeMessage mimeMessage = this.createMimeMessage(this.session);
        String string = this.getHeader("Subject", null);
        if (string != null) {
            if (!string.regionMatches(true, 0, "Re: ", 0, 4)) {
                string = new StringBuffer().append("Re: ").append(string).toString();
            }
            mimeMessage.setHeader("Subject", string);
        }
        Address[] addressArray = this.getReplyTo();
        mimeMessage.setRecipients(Message.RecipientType.TO, addressArray);
        if (bl2) {
            object2 = new Vector();
            object = InternetAddress.getLocalAddress((Session)this.session);
            if (object != null) {
                ((Vector)object2).addElement(object);
            }
            String string2 = null;
            if (this.session != null) {
                string2 = this.session.getProperty("mail.alternates");
            }
            if (string2 != null) {
                this.eliminateDuplicates((Vector)object2, (Address[])InternetAddress.parse((String)string2, (boolean)false));
            }
            Object var8_9 = null;
            boolean bl3 = false;
            if (this.session != null) {
                bl3 = PropUtil.getBooleanSessionProperty((Session)this.session, (String)"mail.replyallcc", (boolean)false);
            }
            this.eliminateDuplicates((Vector)object2, addressArray);
            addressArray = this.getRecipients(Message.RecipientType.TO);
            addressArray = this.eliminateDuplicates((Vector)object2, addressArray);
            if (addressArray != null && addressArray.length > 0) {
                if (bl3) {
                    mimeMessage.addRecipients(Message.RecipientType.CC, addressArray);
                } else {
                    mimeMessage.addRecipients(Message.RecipientType.TO, addressArray);
                }
            }
            addressArray = this.getRecipients(Message.RecipientType.CC);
            if ((addressArray = this.eliminateDuplicates((Vector)object2, addressArray)) != null && addressArray.length > 0) {
                mimeMessage.addRecipients(Message.RecipientType.CC, addressArray);
            }
            if ((addressArray = this.getRecipients((Message.RecipientType)RecipientType.NEWSGROUPS)) != null && addressArray.length > 0) {
                mimeMessage.setRecipients((Message.RecipientType)RecipientType.NEWSGROUPS, addressArray);
            }
        }
        if ((object2 = this.getHeader("Message-Id", null)) != null) {
            mimeMessage.setHeader("In-Reply-To", (String)object2);
        }
        if ((object = this.getHeader("References", " ")) == null) {
            object = this.getHeader("In-Reply-To", " ");
        }
        if (object2 != null) {
            object = object != null ? new StringBuffer().append(MimeUtility.unfold((String)object)).append(" ").append((String)object2).toString() : object2;
        }
        if (object != null) {
            mimeMessage.setHeader("References", MimeUtility.fold((int)12, (String)object));
        }
        try {
            this.setFlags(answeredFlag, true);
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return mimeMessage;
    }

    private Address[] eliminateDuplicates(Vector vector, Address[] addressArray) {
        int n2;
        int n3;
        if (addressArray == null) {
            return null;
        }
        int n4 = 0;
        for (int i2 = 0; i2 < addressArray.length; ++i2) {
            n3 = 0;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                if (!((InternetAddress)vector.elementAt(n2)).equals((Object)addressArray[i2])) continue;
                n3 = 1;
                ++n4;
                addressArray[i2] = null;
                break;
            }
            if (n3 != 0) continue;
            vector.addElement(addressArray[i2]);
        }
        if (n4 != 0) {
            Object[] objectArray = addressArray instanceof InternetAddress[] ? new InternetAddress[addressArray.length - n4] : new Address[addressArray.length - n4];
            n2 = 0;
            for (n3 = 0; n3 < addressArray.length; ++n3) {
                if (addressArray[n3] == null) continue;
                objectArray[n2++] = addressArray[n3];
            }
            addressArray = objectArray;
        }
        return addressArray;
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        this.writeTo(outputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream, String[] stringArray) throws IOException, MessagingException {
        if (!this.saved) {
            this.saveChanges();
        }
        if (this.modified) {
            MimeBodyPart.writeTo((MimePart)this, (OutputStream)outputStream, (String[])stringArray);
            return;
        }
        Enumeration enumeration = this.getNonMatchingHeaderLines(stringArray);
        LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
        while (enumeration.hasMoreElements()) {
            lineOutputStream.writeln((String)enumeration.nextElement());
        }
        lineOutputStream.writeln();
        if (this.content == null) {
            InputStream inputStream = null;
            byte[] byArray = new byte[8192];
            try {
                int n2;
                inputStream = this.getContentStream();
                while ((n2 = inputStream.read(byArray)) > 0) {
                    outputStream.write(byArray, 0, n2);
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                byArray = null;
            }
        } else {
            outputStream.write(this.content);
        }
        outputStream.flush();
    }

    public String[] getHeader(String string) throws MessagingException {
        return this.headers.getHeader(string);
    }

    public String getHeader(String string, String string2) throws MessagingException {
        return this.headers.getHeader(string, string2);
    }

    public void setHeader(String string, String string2) throws MessagingException {
        this.headers.setHeader(string, string2);
    }

    public void addHeader(String string, String string2) throws MessagingException {
        this.headers.addHeader(string, string2);
    }

    public void removeHeader(String string) throws MessagingException {
        this.headers.removeHeader(string);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        return this.headers.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] stringArray) throws MessagingException {
        return this.headers.getMatchingHeaders(stringArray);
    }

    public Enumeration getNonMatchingHeaders(String[] stringArray) throws MessagingException {
        return this.headers.getNonMatchingHeaders(stringArray);
    }

    public void addHeaderLine(String string) throws MessagingException {
        this.headers.addHeaderLine(string);
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] stringArray) throws MessagingException {
        return this.headers.getMatchingHeaderLines(stringArray);
    }

    public Enumeration getNonMatchingHeaderLines(String[] stringArray) throws MessagingException {
        return this.headers.getNonMatchingHeaderLines(stringArray);
    }

    public synchronized Flags getFlags() throws MessagingException {
        return (Flags)this.flags.clone();
    }

    public synchronized boolean isSet(Flags.Flag flag) throws MessagingException {
        return this.flags.contains(flag);
    }

    public synchronized void setFlags(Flags flags, boolean bl2) throws MessagingException {
        if (bl2) {
            this.flags.add(flags);
        } else {
            this.flags.remove(flags);
        }
    }

    public void saveChanges() throws MessagingException {
        this.modified = true;
        this.saved = true;
        this.updateHeaders();
    }

    protected void updateMessageID() throws MessagingException {
        this.setHeader("Message-ID", new StringBuffer().append("<").append(UniqueValue.getUniqueMessageIDValue((Session)this.session)).append(">").toString());
    }

    protected synchronized void updateHeaders() throws MessagingException {
        MimeBodyPart.updateHeaders((MimePart)this);
        this.setHeader("MIME-Version", "1.0");
        this.updateMessageID();
        if (this.cachedContent != null) {
            this.dh = new DataHandler(this.cachedContent, this.getContentType());
            this.cachedContent = null;
            this.content = null;
            if (this.contentStream != null) {
                try {
                    this.contentStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.contentStream = null;
        }
    }

    protected InternetHeaders createInternetHeaders(InputStream inputStream) throws MessagingException {
        return new InternetHeaders(inputStream);
    }

    protected MimeMessage createMimeMessage(Session session) throws MessagingException {
        return new MimeMessage(session);
    }
}

