/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.javax.mail_1_4_7.internet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import macromedia.externals.com.sun.mail_1_4_7.util.ASCIIUtility;
import macromedia.externals.com.sun.mail_1_4_7.util.FolderClosedIOException;
import macromedia.externals.com.sun.mail_1_4_7.util.LineOutputStream;
import macromedia.externals.com.sun.mail_1_4_7.util.MessageRemovedIOException;
import macromedia.externals.com.sun.mail_1_4_7.util.MimeUtil;
import macromedia.externals.com.sun.mail_1_4_7.util.PropUtil;
import macromedia.externals.javax.mail_1_4_7.BodyPart;
import macromedia.externals.javax.mail_1_4_7.FolderClosedException;
import macromedia.externals.javax.mail_1_4_7.Message;
import macromedia.externals.javax.mail_1_4_7.MessageRemovedException;
import macromedia.externals.javax.mail_1_4_7.MessagingException;
import macromedia.externals.javax.mail_1_4_7.Multipart;
import macromedia.externals.javax.mail_1_4_7.Part;
import macromedia.externals.javax.mail_1_4_7.internet.ContentDisposition;
import macromedia.externals.javax.mail_1_4_7.internet.ContentType;
import macromedia.externals.javax.mail_1_4_7.internet.HeaderTokenizer;
import macromedia.externals.javax.mail_1_4_7.internet.InternetHeaders;
import macromedia.externals.javax.mail_1_4_7.internet.MimeBodyPart;
import macromedia.externals.javax.mail_1_4_7.internet.MimeMessage;
import macromedia.externals.javax.mail_1_4_7.internet.MimeMultipart;
import macromedia.externals.javax.mail_1_4_7.internet.MimePart;
import macromedia.externals.javax.mail_1_4_7.internet.MimePartDataSource;
import macromedia.externals.javax.mail_1_4_7.internet.MimeUtility;
import macromedia.externals.javax.mail_1_4_7.internet.ParseException;
import macromedia.externals.javax.mail_1_4_7.internet.SharedInputStream;

/*
 * Exception performing whole class analysis ignored.
 */
public class MimeBodyPart
extends BodyPart
implements MimePart {
    private static final boolean setDefaultTextCharset = PropUtil.getBooleanSystemProperty((String)"mail.mime.setdefaulttextcharset", (boolean)true);
    private static final boolean setContentTypeFileName = PropUtil.getBooleanSystemProperty((String)"mail.mime.setcontenttypefilename", (boolean)true);
    private static final boolean encodeFileName = PropUtil.getBooleanSystemProperty((String)"mail.mime.encodefilename", (boolean)false);
    private static final boolean decodeFileName = PropUtil.getBooleanSystemProperty((String)"mail.mime.decodefilename", (boolean)false);
    private static final boolean ignoreMultipartEncoding = PropUtil.getBooleanSystemProperty((String)"mail.mime.ignoremultipartencoding", (boolean)true);
    static final boolean cacheMultipart = PropUtil.getBooleanSystemProperty((String)"mail.mime.cachemultipart", (boolean)true);
    protected DataHandler dh;
    protected byte[] content;
    protected InputStream contentStream;
    protected InternetHeaders headers;
    private Object cachedContent;

    public MimeBodyPart() {
        this.headers = new InternetHeaders();
    }

    public MimeBodyPart(InputStream inputStream) throws MessagingException {
        if (!(inputStream instanceof ByteArrayInputStream || inputStream instanceof BufferedInputStream || inputStream instanceof SharedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.headers = new InternetHeaders(inputStream);
        if (inputStream instanceof SharedInputStream) {
            SharedInputStream sharedInputStream = (SharedInputStream)inputStream;
            this.contentStream = sharedInputStream.newStream(sharedInputStream.getPosition(), -1L);
        } else {
            try {
                this.content = ASCIIUtility.getBytes((InputStream)inputStream);
            }
            catch (IOException iOException) {
                throw new MessagingException("Error reading input stream", (Exception)iOException);
            }
        }
    }

    public MimeBodyPart(InternetHeaders internetHeaders, byte[] byArray) throws MessagingException {
        this.headers = internetHeaders;
        this.content = byArray;
    }

    public int getSize() throws MessagingException {
        if (this.content != null) {
            return this.content.length;
        }
        if (this.contentStream != null) {
            try {
                int n2 = this.contentStream.available();
                if (n2 > 0) {
                    return n2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getLineCount() throws MessagingException {
        return -1;
    }

    public String getContentType() throws MessagingException {
        String string = this.getHeader("Content-Type", null);
        if ((string = MimeUtil.cleanContentType((MimePart)this, (String)string)) == null) {
            string = "text/plain";
        }
        return string;
    }

    public boolean isMimeType(String string) throws MessagingException {
        return MimeBodyPart.isMimeType((MimePart)this, (String)string);
    }

    public String getDisposition() throws MessagingException {
        return MimeBodyPart.getDisposition((MimePart)this);
    }

    public void setDisposition(String string) throws MessagingException {
        MimeBodyPart.setDisposition((MimePart)this, (String)string);
    }

    public String getEncoding() throws MessagingException {
        return MimeBodyPart.getEncoding((MimePart)this);
    }

    public String getContentID() throws MessagingException {
        return this.getHeader("Content-Id", null);
    }

    public void setContentID(String string) throws MessagingException {
        if (string == null) {
            this.removeHeader("Content-ID");
        } else {
            this.setHeader("Content-ID", string);
        }
    }

    public String getContentMD5() throws MessagingException {
        return this.getHeader("Content-MD5", null);
    }

    public void setContentMD5(String string) throws MessagingException {
        this.setHeader("Content-MD5", string);
    }

    public String[] getContentLanguage() throws MessagingException {
        return MimeBodyPart.getContentLanguage((MimePart)this);
    }

    public void setContentLanguage(String[] stringArray) throws MessagingException {
        MimeBodyPart.setContentLanguage((MimePart)this, (String[])stringArray);
    }

    public String getDescription() throws MessagingException {
        return MimeBodyPart.getDescription((MimePart)this);
    }

    public void setDescription(String string) throws MessagingException {
        this.setDescription(string, null);
    }

    public void setDescription(String string, String string2) throws MessagingException {
        MimeBodyPart.setDescription((MimePart)this, (String)string, (String)string2);
    }

    public String getFileName() throws MessagingException {
        return MimeBodyPart.getFileName((MimePart)this);
    }

    public void setFileName(String string) throws MessagingException {
        MimeBodyPart.setFileName((MimePart)this, (String)string);
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        return this.getDataHandler().getInputStream();
    }

    protected InputStream getContentStream() throws MessagingException {
        if (this.contentStream != null) {
            return ((SharedInputStream)this.contentStream).newStream(0L, -1L);
        }
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        throw new MessagingException("No MimeBodyPart content");
    }

    public InputStream getRawInputStream() throws MessagingException {
        return this.getContentStream();
    }

    public DataHandler getDataHandler() throws MessagingException {
        if (this.dh == null) {
            this.dh = new MimePartDataHandler((DataSource)new MimePartDataSource((MimePart)this));
        }
        return this.dh;
    }

    public Object getContent() throws IOException, MessagingException {
        Object object;
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        try {
            object = this.getDataHandler().getContent();
        }
        catch (FolderClosedIOException folderClosedIOException) {
            throw new FolderClosedException(folderClosedIOException.getFolder(), folderClosedIOException.getMessage());
        }
        catch (MessageRemovedIOException messageRemovedIOException) {
            throw new MessageRemovedException(messageRemovedIOException.getMessage());
        }
        if (cacheMultipart && (object instanceof Multipart || object instanceof Message) && (this.content != null || this.contentStream != null)) {
            this.cachedContent = object;
            if (object instanceof MimeMultipart) {
                ((MimeMultipart)object).parse();
            }
        }
        return object;
    }

    public void setDataHandler(DataHandler dataHandler) throws MessagingException {
        this.dh = dataHandler;
        this.cachedContent = null;
        MimeBodyPart.invalidateContentHeaders((MimePart)this);
    }

    public void setContent(Object object, String string) throws MessagingException {
        if (object instanceof Multipart) {
            this.setContent((Multipart)object);
        } else {
            this.setDataHandler(new DataHandler(object, string));
        }
    }

    public void setText(String string) throws MessagingException {
        this.setText(string, null);
    }

    public void setText(String string, String string2) throws MessagingException {
        MimeBodyPart.setText((MimePart)this, (String)string, (String)string2, (String)"plain");
    }

    public void setText(String string, String string2, String string3) throws MessagingException {
        MimeBodyPart.setText((MimePart)this, (String)string, (String)string2, (String)string3);
    }

    public void setContent(Multipart multipart) throws MessagingException {
        this.setDataHandler(new DataHandler((Object)multipart, multipart.getContentType()));
        multipart.setParent((Part)this);
    }

    public void attachFile(File file) throws IOException, MessagingException {
        FileDataSource fileDataSource = new FileDataSource(file);
        this.setDataHandler(new DataHandler((DataSource)fileDataSource));
        this.setFileName(fileDataSource.getName());
    }

    public void attachFile(String string) throws IOException, MessagingException {
        File file = new File(string);
        this.attachFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(File file) throws IOException, MessagingException {
        BufferedOutputStream bufferedOutputStream = null;
        InputStream inputStream = null;
        try {
            int n2;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            inputStream = this.getInputStream();
            byte[] byArray = new byte[8192];
            while ((n2 = inputStream.read(byArray)) > 0) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n2);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bufferedOutputStream != null) {
                    ((OutputStream)bufferedOutputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void saveFile(String string) throws IOException, MessagingException {
        File file = new File(string);
        this.saveFile(file);
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        MimeBodyPart.writeTo((MimePart)this, (OutputStream)outputStream, null);
    }

    public String[] getHeader(String string) throws MessagingException {
        return this.headers.getHeader(string);
    }

    public String getHeader(String string, String string2) throws MessagingException {
        return this.headers.getHeader(string, string2);
    }

    public void setHeader(String string, String string2) throws MessagingException {
        this.headers.setHeader(string, string2);
    }

    public void addHeader(String string, String string2) throws MessagingException {
        this.headers.addHeader(string, string2);
    }

    public void removeHeader(String string) throws MessagingException {
        this.headers.removeHeader(string);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        return this.headers.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] stringArray) throws MessagingException {
        return this.headers.getMatchingHeaders(stringArray);
    }

    public Enumeration getNonMatchingHeaders(String[] stringArray) throws MessagingException {
        return this.headers.getNonMatchingHeaders(stringArray);
    }

    public void addHeaderLine(String string) throws MessagingException {
        this.headers.addHeaderLine(string);
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] stringArray) throws MessagingException {
        return this.headers.getMatchingHeaderLines(stringArray);
    }

    public Enumeration getNonMatchingHeaderLines(String[] stringArray) throws MessagingException {
        return this.headers.getNonMatchingHeaderLines(stringArray);
    }

    protected void updateHeaders() throws MessagingException {
        MimeBodyPart.updateHeaders((MimePart)this);
        if (this.cachedContent != null) {
            this.dh = new DataHandler(this.cachedContent, this.getContentType());
            this.cachedContent = null;
            this.content = null;
            if (this.contentStream != null) {
                try {
                    this.contentStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.contentStream = null;
        }
    }

    static boolean isMimeType(MimePart mimePart, String string) throws MessagingException {
        try {
            ContentType contentType = new ContentType(mimePart.getContentType());
            return contentType.match(string);
        }
        catch (ParseException parseException) {
            return mimePart.getContentType().equalsIgnoreCase(string);
        }
    }

    static void setText(MimePart mimePart, String string, String string2, String string3) throws MessagingException {
        if (string2 == null) {
            string2 = MimeUtility.checkAscii((String)string) != 1 ? MimeUtility.getDefaultMIMECharset() : "us-ascii";
        }
        mimePart.setContent((Object)string, new StringBuffer().append("text/").append(string3).append("; charset=").append(MimeUtility.quote((String)string2, (String)"()<>@,;:\\\"\t []/?=")).toString());
    }

    static String getDisposition(MimePart mimePart) throws MessagingException {
        String string = mimePart.getHeader("Content-Disposition", null);
        if (string == null) {
            return null;
        }
        ContentDisposition contentDisposition = new ContentDisposition(string);
        return contentDisposition.getDisposition();
    }

    static void setDisposition(MimePart mimePart, String string) throws MessagingException {
        if (string == null) {
            mimePart.removeHeader("Content-Disposition");
        } else {
            String string2 = mimePart.getHeader("Content-Disposition", null);
            if (string2 != null) {
                ContentDisposition contentDisposition = new ContentDisposition(string2);
                contentDisposition.setDisposition(string);
                string = contentDisposition.toString();
            }
            mimePart.setHeader("Content-Disposition", string);
        }
    }

    static String getDescription(MimePart mimePart) throws MessagingException {
        String string = mimePart.getHeader("Content-Description", null);
        if (string == null) {
            return null;
        }
        try {
            return MimeUtility.decodeText((String)MimeUtility.unfold((String)string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    static void setDescription(MimePart mimePart, String string, String string2) throws MessagingException {
        if (string == null) {
            mimePart.removeHeader("Content-Description");
            return;
        }
        try {
            mimePart.setHeader("Content-Description", MimeUtility.fold((int)21, (String)MimeUtility.encodeText((String)string, (String)string2, null)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MessagingException("Encoding error", (Exception)unsupportedEncodingException);
        }
    }

    static String getFileName(MimePart mimePart) throws MessagingException {
        ContentDisposition contentDisposition;
        String string = null;
        String string2 = mimePart.getHeader("Content-Disposition", null);
        if (string2 != null) {
            contentDisposition = new ContentDisposition(string2);
            string = contentDisposition.getParameter("filename");
        }
        if (string == null) {
            string2 = mimePart.getHeader("Content-Type", null);
            if ((string2 = MimeUtil.cleanContentType((MimePart)mimePart, (String)string2)) != null) {
                try {
                    contentDisposition = new ContentType(string2);
                    string = contentDisposition.getParameter("name");
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        if (decodeFileName && string != null) {
            try {
                string = MimeUtility.decodeText((String)string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new MessagingException("Can't decode filename", (Exception)unsupportedEncodingException);
            }
        }
        return string;
    }

    static void setFileName(MimePart mimePart, String string) throws MessagingException {
        String string2;
        if (encodeFileName && string != null) {
            try {
                string = MimeUtility.encodeText((String)string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new MessagingException("Can't encode filename", (Exception)unsupportedEncodingException);
            }
        }
        ContentDisposition contentDisposition = new ContentDisposition((string2 = mimePart.getHeader("Content-Disposition", null)) == null ? "attachment" : string2);
        contentDisposition.setParameter("filename", string);
        mimePart.setHeader("Content-Disposition", contentDisposition.toString());
        if (setContentTypeFileName) {
            string2 = mimePart.getHeader("Content-Type", null);
            if ((string2 = MimeUtil.cleanContentType((MimePart)mimePart, (String)string2)) != null) {
                try {
                    ContentType contentType = new ContentType(string2);
                    contentType.setParameter("name", string);
                    mimePart.setHeader("Content-Type", contentType.toString());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }

    static String[] getContentLanguage(MimePart mimePart) throws MessagingException {
        HeaderTokenizer.Token token;
        int n2;
        String string = mimePart.getHeader("Content-Language", null);
        if (string == null) {
            return null;
        }
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string, "()<>@,;:\\\"\t []/?=");
        Vector<String> vector = new Vector<String>();
        while ((n2 = (token = headerTokenizer.next()).getType()) != -4) {
            if (n2 != -1) continue;
            vector.addElement(token.getValue());
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static void setContentLanguage(MimePart mimePart, String[] stringArray) throws MessagingException {
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n2 = "Content-Language".length() + 2 + stringArray[0].length();
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            stringBuffer.append(',');
            if (++n2 > 76) {
                stringBuffer.append("\r\n\t");
                n2 = 8;
            }
            stringBuffer.append(stringArray[i2]);
            n2 += stringArray[i2].length();
        }
        mimePart.setHeader("Content-Language", stringBuffer.toString());
    }

    static String getEncoding(MimePart mimePart) throws MessagingException {
        HeaderTokenizer.Token token;
        int n2;
        String string = mimePart.getHeader("Content-Transfer-Encoding", null);
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit") || string.equalsIgnoreCase("quoted-printable") || string.equalsIgnoreCase("binary") || string.equalsIgnoreCase("base64")) {
            return string;
        }
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string, "()<>@,;:\\\"\t []/?=");
        while ((n2 = (token = headerTokenizer.next()).getType()) != -4) {
            if (n2 != -1) continue;
            return token.getValue();
        }
        return string;
    }

    static void setEncoding(MimePart mimePart, String string) throws MessagingException {
        mimePart.setHeader("Content-Transfer-Encoding", string);
    }

    static String restrictEncoding(MimePart mimePart, String string) throws MessagingException {
        if (!ignoreMultipartEncoding || string == null) {
            return string;
        }
        if (string.equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit") || string.equalsIgnoreCase("binary")) {
            return string;
        }
        String string2 = mimePart.getContentType();
        if (string2 == null) {
            return string;
        }
        try {
            ContentType contentType = new ContentType(string2);
            if (contentType.match("multipart/*")) {
                return null;
            }
            if (contentType.match("message/*") && !PropUtil.getBooleanSystemProperty((String)"mail.mime.allowencodedmessages", (boolean)false)) {
                return null;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void updateHeaders(MimePart mimePart) throws MessagingException {
        DataHandler dataHandler = mimePart.getDataHandler();
        if (dataHandler == null) {
            return;
        }
        try {
            String string;
            Object object;
            Object object2;
            String string2 = dataHandler.getContentType();
            boolean bl2 = false;
            boolean bl3 = mimePart.getHeader("Content-Type") == null;
            ContentType contentType = new ContentType(string2);
            if (contentType.match("multipart/*")) {
                bl2 = true;
                if (mimePart instanceof MimeBodyPart) {
                    object2 = (MimeBodyPart)mimePart;
                    object = ((MimeBodyPart)object2).cachedContent != null ? ((MimeBodyPart)object2).cachedContent : dataHandler.getContent();
                } else if (mimePart instanceof MimeMessage) {
                    object2 = (MimeMessage)mimePart;
                    object = ((MimeMessage)object2).cachedContent != null ? ((MimeMessage)object2).cachedContent : dataHandler.getContent();
                } else {
                    object = dataHandler.getContent();
                }
                if (!(object instanceof MimeMultipart)) throw new MessagingException(new StringBuffer().append("MIME part of type \"").append(string2).append("\" contains object of type ").append(object.getClass().getName()).append(" instead of MimeMultipart").toString());
                ((MimeMultipart)object).updateHeaders();
            } else if (contentType.match("message/rfc822")) {
                bl2 = true;
            }
            if (dataHandler instanceof MimePartDataHandler) {
                return;
            }
            if (!bl2) {
                if (mimePart.getHeader("Content-Transfer-Encoding") == null) {
                    MimeBodyPart.setEncoding((MimePart)mimePart, (String)MimeUtility.getEncoding((DataHandler)dataHandler));
                }
                if (bl3 && setDefaultTextCharset && contentType.match("text/*") && contentType.getParameter("charset") == null) {
                    object2 = mimePart.getEncoding();
                    object = object2 != null && ((String)object2).equalsIgnoreCase("7bit") ? "us-ascii" : MimeUtility.getDefaultMIMECharset();
                    contentType.setParameter("charset", (String)object);
                    string2 = contentType.toString();
                }
            }
            if (!bl3) return;
            object = mimePart.getHeader("Content-Disposition", null);
            if (object != null && (string = (object2 = new ContentDisposition((String)object)).getParameter("filename")) != null) {
                contentType.setParameter("name", string);
                string2 = contentType.toString();
            }
            mimePart.setHeader("Content-Type", string2);
            return;
        }
        catch (IOException iOException) {
            throw new MessagingException("IOException updating headers", (Exception)iOException);
        }
    }

    static void invalidateContentHeaders(MimePart mimePart) throws MessagingException {
        mimePart.removeHeader("Content-Type");
        mimePart.removeHeader("Content-Transfer-Encoding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeTo(MimePart mimePart, OutputStream outputStream, String[] stringArray) throws IOException, MessagingException {
        LineOutputStream lineOutputStream = null;
        lineOutputStream = outputStream instanceof LineOutputStream ? (LineOutputStream)outputStream : new LineOutputStream(outputStream);
        Enumeration enumeration = mimePart.getNonMatchingHeaderLines(stringArray);
        while (enumeration.hasMoreElements()) {
            lineOutputStream.writeln((String)enumeration.nextElement());
        }
        lineOutputStream.writeln();
        InputStream inputStream = null;
        byte[] byArray = null;
        try {
            DataHandler dataHandler = mimePart.getDataHandler();
            if (dataHandler instanceof MimePartDataHandler) {
                MimeBodyPart mimeBodyPart;
                if (mimePart instanceof MimeBodyPart) {
                    mimeBodyPart = (MimeBodyPart)mimePart;
                    inputStream = mimeBodyPart.getContentStream();
                } else if (mimePart instanceof MimeMessage) {
                    mimeBodyPart = (MimeMessage)mimePart;
                    inputStream = mimeBodyPart.getContentStream();
                }
            }
            if (inputStream != null) {
                int n2;
                byArray = new byte[8192];
                while ((n2 = inputStream.read(byArray)) > 0) {
                    outputStream.write(byArray, 0, n2);
                }
            } else {
                outputStream = MimeUtility.encode((OutputStream)outputStream, (String)MimeBodyPart.restrictEncoding((MimePart)mimePart, (String)mimePart.getEncoding()));
                mimePart.getDataHandler().writeTo(outputStream);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            byArray = null;
        }
        outputStream.flush();
    }
}

