/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.javax.mail_1_4_7;

import java.util.Date;
import macromedia.externals.javax.mail_1_4_7.Address;
import macromedia.externals.javax.mail_1_4_7.Flags;
import macromedia.externals.javax.mail_1_4_7.Folder;
import macromedia.externals.javax.mail_1_4_7.Message;
import macromedia.externals.javax.mail_1_4_7.MessagingException;
import macromedia.externals.javax.mail_1_4_7.MethodNotSupportedException;
import macromedia.externals.javax.mail_1_4_7.Part;
import macromedia.externals.javax.mail_1_4_7.Session;
import macromedia.externals.javax.mail_1_4_7.search.SearchTerm;

public abstract class Message
implements Part {
    protected int msgnum = 0;
    protected boolean expunged = false;
    protected Folder folder = null;
    protected Session session = null;

    protected Message() {
    }

    protected Message(Folder folder, int n2) {
        this.folder = folder;
        this.msgnum = n2;
        this.session = folder.store.session;
    }

    protected Message(Session session) {
        this.session = session;
    }

    public abstract Address[] getFrom() throws MessagingException;

    public abstract void setFrom() throws MessagingException;

    public abstract void setFrom(Address var1) throws MessagingException;

    public abstract void addFrom(Address[] var1) throws MessagingException;

    public abstract Address[] getRecipients(RecipientType var1) throws MessagingException;

    public Address[] getAllRecipients() throws MessagingException {
        Address[] addressArray = this.getRecipients(RecipientType.TO);
        Address[] addressArray2 = this.getRecipients(RecipientType.CC);
        Address[] addressArray3 = this.getRecipients(RecipientType.BCC);
        if (addressArray2 == null && addressArray3 == null) {
            return addressArray;
        }
        int n2 = (addressArray != null ? addressArray.length : 0) + (addressArray2 != null ? addressArray2.length : 0) + (addressArray3 != null ? addressArray3.length : 0);
        Address[] addressArray4 = new Address[n2];
        int n3 = 0;
        if (addressArray != null) {
            System.arraycopy(addressArray, 0, addressArray4, n3, addressArray.length);
            n3 += addressArray.length;
        }
        if (addressArray2 != null) {
            System.arraycopy(addressArray2, 0, addressArray4, n3, addressArray2.length);
            n3 += addressArray2.length;
        }
        if (addressArray3 != null) {
            System.arraycopy(addressArray3, 0, addressArray4, n3, addressArray3.length);
            n3 += addressArray3.length;
        }
        return addressArray4;
    }

    public abstract void setRecipients(RecipientType var1, Address[] var2) throws MessagingException;

    public void setRecipient(RecipientType recipientType, Address address) throws MessagingException {
        Address[] addressArray = new Address[]{address};
        this.setRecipients(recipientType, addressArray);
    }

    public abstract void addRecipients(RecipientType var1, Address[] var2) throws MessagingException;

    public void addRecipient(RecipientType recipientType, Address address) throws MessagingException {
        Address[] addressArray = new Address[]{address};
        this.addRecipients(recipientType, addressArray);
    }

    public Address[] getReplyTo() throws MessagingException {
        return this.getFrom();
    }

    public void setReplyTo(Address[] addressArray) throws MessagingException {
        throw new MethodNotSupportedException("setReplyTo not supported");
    }

    public abstract String getSubject() throws MessagingException;

    public abstract void setSubject(String var1) throws MessagingException;

    public abstract Date getSentDate() throws MessagingException;

    public abstract void setSentDate(Date var1) throws MessagingException;

    public abstract Date getReceivedDate() throws MessagingException;

    public abstract Flags getFlags() throws MessagingException;

    public boolean isSet(Flags.Flag flag) throws MessagingException {
        return this.getFlags().contains(flag);
    }

    public abstract void setFlags(Flags var1, boolean var2) throws MessagingException;

    public void setFlag(Flags.Flag flag, boolean bl2) throws MessagingException {
        Flags flags = new Flags(flag);
        this.setFlags(flags, bl2);
    }

    public int getMessageNumber() {
        return this.msgnum;
    }

    protected void setMessageNumber(int n2) {
        this.msgnum = n2;
    }

    public Folder getFolder() {
        return this.folder;
    }

    public boolean isExpunged() {
        return this.expunged;
    }

    protected void setExpunged(boolean bl2) {
        this.expunged = bl2;
    }

    public abstract Message reply(boolean var1) throws MessagingException;

    public abstract void saveChanges() throws MessagingException;

    public boolean match(SearchTerm searchTerm) throws MessagingException {
        return searchTerm.match(this);
    }
}

