/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import macromedia.externals.com.sun.mail_1_4_7.util.DecodingException;
import macromedia.externals.com.sun.mail_1_4_7.util.LineInputStream;
import macromedia.externals.com.sun.mail_1_4_7.util.PropUtil;

public class UUDecoderStream
extends FilterInputStream {
    private String name;
    private int mode;
    private byte[] buffer = new byte[45];
    private int bufsize = 0;
    private int index = 0;
    private boolean gotPrefix = false;
    private boolean gotEnd = false;
    private LineInputStream lin;
    private boolean ignoreErrors;
    private boolean ignoreMissingBeginEnd;
    private String readAhead;

    public UUDecoderStream(InputStream inputStream) {
        super(inputStream);
        this.lin = new LineInputStream(inputStream);
        this.ignoreErrors = PropUtil.getBooleanSystemProperty((String)"mail.mime.uudecode.ignoreerrors", (boolean)false);
        this.ignoreMissingBeginEnd = PropUtil.getBooleanSystemProperty((String)"mail.mime.uudecode.ignoremissingbeginend", (boolean)false);
    }

    public UUDecoderStream(InputStream inputStream, boolean bl2, boolean bl3) {
        super(inputStream);
        this.lin = new LineInputStream(inputStream);
        this.ignoreErrors = bl2;
        this.ignoreMissingBeginEnd = bl3;
    }

    @Override
    public int read() throws IOException {
        if (this.index >= this.bufsize) {
            this.readPrefix();
            if (!this.decode()) {
                return -1;
            }
            this.index = 0;
        }
        return this.buffer[this.index++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        for (n4 = 0; n4 < n3; ++n4) {
            int n5 = this.read();
            if (n5 == -1) {
                if (n4 != 0) break;
                n4 = -1;
                break;
            }
            byArray[n2 + n4] = (byte)n5;
        }
        return n4;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() throws IOException {
        return this.in.available() * 3 / 4 + (this.bufsize - this.index);
    }

    public String getName() throws IOException {
        this.readPrefix();
        return this.name;
    }

    public int getMode() throws IOException {
        this.readPrefix();
        return this.mode;
    }

    private void readPrefix() throws IOException {
        block10: {
            String string;
            if (this.gotPrefix) {
                return;
            }
            this.mode = 438;
            this.name = "encoder.buf";
            while (true) {
                if ((string = this.lin.readLine()) == null) {
                    if (!this.ignoreMissingBeginEnd) {
                        throw new DecodingException("UUDecoder: Missing begin");
                    }
                    this.gotPrefix = true;
                    this.gotEnd = true;
                    break block10;
                }
                if (string.regionMatches(false, 0, "begin", 0, 5)) {
                    block11: {
                        try {
                            this.mode = Integer.parseInt(string.substring(6, 9));
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (this.ignoreErrors) break block11;
                            throw new DecodingException(new StringBuffer().append("UUDecoder: Error in mode: ").append(numberFormatException.toString()).toString());
                        }
                    }
                    if (string.length() > 10) {
                        this.name = string.substring(10);
                    } else if (!this.ignoreErrors) {
                        throw new DecodingException(new StringBuffer().append("UUDecoder: Missing name: ").append(string).toString());
                    }
                    this.gotPrefix = true;
                    break block10;
                }
                if (!this.ignoreMissingBeginEnd || string.length() == 0) continue;
                int n2 = string.charAt(0);
                int n3 = ((n2 = n2 - 32 & 0x3F) * 8 + 5) / 6;
                if (n3 == 0 || string.length() >= n3 + 1) break;
            }
            this.readAhead = string;
            this.gotPrefix = true;
        }
    }

    private boolean decode() throws IOException {
        int n2;
        String string;
        int n3;
        block12: {
            if (this.gotEnd) {
                return false;
            }
            this.bufsize = 0;
            n3 = 0;
            while (true) {
                if (this.readAhead != null) {
                    string = this.readAhead;
                    this.readAhead = null;
                } else {
                    string = this.lin.readLine();
                }
                if (string == null) {
                    if (!this.ignoreMissingBeginEnd) {
                        throw new DecodingException("UUDecoder: Missing end at EOF");
                    }
                    this.gotEnd = true;
                    return false;
                }
                if (string.equals("end")) {
                    this.gotEnd = true;
                    return false;
                }
                if (string.length() == 0) continue;
                n3 = string.charAt(0);
                if (n3 < 32) {
                    if (this.ignoreErrors) continue;
                    throw new DecodingException("UUDecoder: Buffer format error");
                }
                if ((n3 = n3 - 32 & 0x3F) == 0) {
                    string = this.lin.readLine();
                    if (!(string != null && string.equals("end") || this.ignoreMissingBeginEnd)) {
                        throw new DecodingException("UUDecoder: Missing End after count 0 line");
                    }
                    this.gotEnd = true;
                    return false;
                }
                n2 = (n3 * 8 + 5) / 6;
                if (string.length() >= n2 + 1) break block12;
                if (!this.ignoreErrors) break;
            }
            throw new DecodingException("UUDecoder: Short buffer error");
        }
        n2 = 1;
        while (this.bufsize < n3) {
            byte by2 = (byte)(string.charAt(n2++) - 32 & 0x3F);
            byte by3 = (byte)(string.charAt(n2++) - 32 & 0x3F);
            this.buffer[this.bufsize++] = (byte)(by2 << 2 & 0xFC | by3 >>> 4 & 3);
            if (this.bufsize < n3) {
                by2 = by3;
                by3 = (byte)(string.charAt(n2++) - 32 & 0x3F);
                this.buffer[this.bufsize++] = (byte)(by2 << 4 & 0xF0 | by3 >>> 2 & 0xF);
            }
            if (this.bufsize >= n3) continue;
            by2 = by3;
            by3 = (byte)(string.charAt(n2++) - 32 & 0x3F);
            this.buffer[this.bufsize++] = (byte)(by2 << 6 & 0xC0 | by3 & 0x3F);
        }
        return true;
    }
}

