/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import macromedia.externals.com.sun.mail_1_4_7.util.LogOutputStream;
import macromedia.externals.com.sun.mail_1_4_7.util.MailLogger;

public class TraceOutputStream
extends FilterOutputStream {
    private boolean trace = false;
    private boolean quote = false;
    private OutputStream traceOut;

    public TraceOutputStream(OutputStream outputStream, MailLogger mailLogger) {
        super(outputStream);
        this.trace = mailLogger.isLoggable(Level.FINEST);
        this.traceOut = new LogOutputStream(mailLogger);
    }

    public TraceOutputStream(OutputStream outputStream, OutputStream outputStream2) {
        super(outputStream);
        this.traceOut = outputStream2;
    }

    public void setTrace(boolean bl2) {
        this.trace = bl2;
    }

    public void setQuote(boolean bl2) {
        this.quote = bl2;
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.trace) {
            if (this.quote) {
                this.writeByte(n2);
            } else {
                this.traceOut.write(n2);
            }
        }
        this.out.write(n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (this.trace) {
            if (this.quote) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.writeByte((int)byArray[n2 + i2]);
                }
            } else {
                this.traceOut.write(byArray, n2, n3);
            }
        }
        this.out.write(byArray, n2, n3);
    }

    private final void writeByte(int n2) throws IOException {
        if ((n2 &= 0xFF) > 127) {
            this.traceOut.write(77);
            this.traceOut.write(45);
            n2 &= 0x7F;
        }
        if (n2 == 13) {
            this.traceOut.write(92);
            this.traceOut.write(114);
        } else if (n2 == 10) {
            this.traceOut.write(92);
            this.traceOut.write(110);
            this.traceOut.write(10);
        } else if (n2 == 9) {
            this.traceOut.write(92);
            this.traceOut.write(116);
        } else if (n2 < 32) {
            this.traceOut.write(94);
            this.traceOut.write(64 + n2);
        } else {
            this.traceOut.write(n2);
        }
    }
}

