/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import macromedia.externals.com.sun.mail_1_4_7.util.LogOutputStream;
import macromedia.externals.com.sun.mail_1_4_7.util.MailLogger;

public class TraceInputStream
extends FilterInputStream {
    private boolean trace = false;
    private boolean quote = false;
    private OutputStream traceOut;

    public TraceInputStream(InputStream inputStream, MailLogger mailLogger) {
        super(inputStream);
        this.trace = mailLogger.isLoggable(Level.FINEST);
        this.traceOut = new LogOutputStream(mailLogger);
    }

    public TraceInputStream(InputStream inputStream, OutputStream outputStream) {
        super(inputStream);
        this.traceOut = outputStream;
    }

    public void setTrace(boolean bl2) {
        this.trace = bl2;
    }

    public void setQuote(boolean bl2) {
        this.quote = bl2;
    }

    @Override
    public int read() throws IOException {
        int n2 = this.in.read();
        if (this.trace && n2 != -1) {
            if (this.quote) {
                this.writeByte(n2);
            } else {
                this.traceOut.write(n2);
            }
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.in.read(byArray, n2, n3);
        if (this.trace && n4 != -1) {
            if (this.quote) {
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.writeByte((int)byArray[n2 + i2]);
                }
            } else {
                this.traceOut.write(byArray, n2, n4);
            }
        }
        return n4;
    }

    private final void writeByte(int n2) throws IOException {
        if ((n2 &= 0xFF) > 127) {
            this.traceOut.write(77);
            this.traceOut.write(45);
            n2 &= 0x7F;
        }
        if (n2 == 13) {
            this.traceOut.write(92);
            this.traceOut.write(114);
        } else if (n2 == 10) {
            this.traceOut.write(92);
            this.traceOut.write(110);
            this.traceOut.write(10);
        } else if (n2 == 9) {
            this.traceOut.write(92);
            this.traceOut.write(116);
        } else if (n2 < 32) {
            this.traceOut.write(94);
            this.traceOut.write(64 + n2);
        } else {
            this.traceOut.write(n2);
        }
    }
}

