/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.pop3;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import macromedia.externals.com.sun.mail_1_4_7.pop3.DefaultFolder;
import macromedia.externals.com.sun.mail_1_4_7.pop3.POP3Message;
import macromedia.externals.com.sun.mail_1_4_7.pop3.POP3Store;
import macromedia.externals.com.sun.mail_1_4_7.pop3.Protocol;
import macromedia.externals.com.sun.mail_1_4_7.pop3.Status;
import macromedia.externals.com.sun.mail_1_4_7.pop3.TempFile;
import macromedia.externals.com.sun.mail_1_4_7.util.LineInputStream;
import macromedia.externals.com.sun.mail_1_4_7.util.MailLogger;
import macromedia.externals.javax.mail_1_4_7.FetchProfile;
import macromedia.externals.javax.mail_1_4_7.Flags;
import macromedia.externals.javax.mail_1_4_7.Folder;
import macromedia.externals.javax.mail_1_4_7.FolderClosedException;
import macromedia.externals.javax.mail_1_4_7.FolderNotFoundException;
import macromedia.externals.javax.mail_1_4_7.Message;
import macromedia.externals.javax.mail_1_4_7.MessageRemovedException;
import macromedia.externals.javax.mail_1_4_7.MessagingException;
import macromedia.externals.javax.mail_1_4_7.MethodNotSupportedException;
import macromedia.externals.javax.mail_1_4_7.Store;
import macromedia.externals.javax.mail_1_4_7.UIDFolder;

public class POP3Folder
extends Folder {
    private String name;
    private POP3Store store;
    private volatile Protocol port;
    private int total;
    private int size;
    private boolean exists = false;
    private volatile boolean opened = false;
    private Vector message_cache;
    private boolean doneUidl = false;
    private volatile TempFile fileCache = null;
    MailLogger logger;

    POP3Folder(POP3Store pOP3Store, String string) {
        super((Store)pOP3Store);
        this.name = string;
        this.store = pOP3Store;
        if (string.equalsIgnoreCase("INBOX")) {
            this.exists = true;
        }
        this.logger = new MailLogger(this.getClass(), "DEBUG POP3", pOP3Store.getSession());
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.name;
    }

    public Folder getParent() {
        return new DefaultFolder(this.store);
    }

    public boolean exists() {
        return this.exists;
    }

    public Folder[] list(String string) throws MessagingException {
        throw new MessagingException("not a directory");
    }

    public char getSeparator() {
        return '\u0000';
    }

    public int getType() {
        return 1;
    }

    public boolean create(int n2) throws MessagingException {
        return false;
    }

    public boolean hasNewMessages() throws MessagingException {
        return false;
    }

    public Folder getFolder(String string) throws MessagingException {
        throw new MessagingException("not a directory");
    }

    public boolean delete(boolean bl2) throws MessagingException {
        throw new MethodNotSupportedException("delete");
    }

    public boolean renameTo(Folder folder) throws MessagingException {
        throw new MethodNotSupportedException("renameTo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open(int n2) throws MessagingException {
        this.checkClosed();
        if (!this.exists) {
            throw new FolderNotFoundException((Folder)this, "folder is not INBOX");
        }
        try {
            this.port = this.store.getPort(this);
            Status status = this.port.stat();
            this.total = status.total;
            this.size = status.size;
            this.mode = n2;
            if (this.store.useFileCache) {
                try {
                    this.fileCache = new TempFile(this.store.fileCacheDir);
                }
                catch (IOException iOException) {
                    this.logger.log(Level.FINE, "failed to create file cache", (Throwable)iOException);
                    throw iOException;
                }
            }
            this.opened = true;
        }
        catch (IOException iOException) {
            try {
                if (this.port != null) {
                    this.port.quit();
                }
            }
            catch (IOException iOException2) {
            }
            finally {
                this.port = null;
                this.store.closePort(this);
            }
            throw new MessagingException("Open failed", (Exception)iOException);
        }
        this.message_cache = new Vector(this.total);
        this.message_cache.setSize(this.total);
        this.doneUidl = false;
        this.notifyConnectionListeners(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean bl2) throws MessagingException {
        this.checkOpen();
        try {
            POP3Message pOP3Message;
            int n2;
            if (this.store.rsetBeforeQuit) {
                this.port.rset();
            }
            if (bl2 && this.mode == 2) {
                for (n2 = 0; n2 < this.message_cache.size(); ++n2) {
                    pOP3Message = (POP3Message)this.message_cache.elementAt(n2);
                    if (pOP3Message == null || !pOP3Message.isSet(Flags.Flag.DELETED)) continue;
                    try {
                        this.port.dele(n2 + 1);
                        continue;
                    }
                    catch (IOException iOException) {
                        throw new MessagingException("Exception deleting messages during close", (Exception)iOException);
                    }
                }
            }
            for (n2 = 0; n2 < this.message_cache.size(); ++n2) {
                pOP3Message = (POP3Message)this.message_cache.elementAt(n2);
                if (pOP3Message == null) continue;
                pOP3Message.invalidate(true);
            }
            this.port.quit();
        }
        catch (IOException iOException) {
        }
        finally {
            this.port = null;
            this.store.closePort(this);
            this.message_cache = null;
            this.opened = false;
            this.notifyConnectionListeners(3);
            if (this.fileCache != null) {
                this.fileCache.close();
                this.fileCache = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isOpen() {
        if (!this.opened) {
            return false;
        }
        try {
            if (!this.port.noop()) {
                throw new IOException("NOOP failed");
            }
        }
        catch (IOException iOException) {
            try {
                try {
                    this.close(false);
                }
                catch (MessagingException messagingException) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public Flags getPermanentFlags() {
        return new Flags();
    }

    public synchronized int getMessageCount() throws MessagingException {
        if (!this.opened) {
            return -1;
        }
        this.checkReadable();
        return this.total;
    }

    public synchronized Message getMessage(int n2) throws MessagingException {
        this.checkOpen();
        POP3Message pOP3Message = (POP3Message)this.message_cache.elementAt(n2 - 1);
        if (pOP3Message == null) {
            pOP3Message = this.createMessage((Folder)this, n2);
            this.message_cache.setElementAt(pOP3Message, n2 - 1);
        }
        return pOP3Message;
    }

    protected POP3Message createMessage(Folder folder, int n2) throws MessagingException {
        POP3Message pOP3Message = null;
        Constructor constructor = this.store.messageConstructor;
        if (constructor != null) {
            try {
                Object[] objectArray = new Object[]{this, new Integer(n2)};
                pOP3Message = (POP3Message)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (pOP3Message == null) {
            pOP3Message = new POP3Message((Folder)this, n2);
        }
        return pOP3Message;
    }

    public void appendMessages(Message[] messageArray) throws MessagingException {
        throw new MethodNotSupportedException("Append not supported");
    }

    public Message[] expunge() throws MessagingException {
        throw new MethodNotSupportedException("Expunge not supported");
    }

    public synchronized void fetch(Message[] messageArray, FetchProfile fetchProfile) throws MessagingException {
        this.checkReadable();
        if (!this.doneUidl && this.store.supportsUidl && fetchProfile.contains((FetchProfile.Item)UIDFolder.FetchProfileItem.UID)) {
            String[] stringArray = new String[this.message_cache.size()];
            try {
                if (!this.port.uidl(stringArray)) {
                    return;
                }
            }
            catch (EOFException eOFException) {
                this.close(false);
                throw new FolderClosedException((Folder)this, eOFException.toString());
            }
            catch (IOException iOException) {
                throw new MessagingException("error getting UIDL", (Exception)iOException);
            }
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2] == null) continue;
                POP3Message pOP3Message = (POP3Message)this.getMessage(i2 + 1);
                pOP3Message.uid = stringArray[i2];
            }
            this.doneUidl = true;
        }
        if (fetchProfile.contains(FetchProfile.Item.ENVELOPE)) {
            for (int i3 = 0; i3 < messageArray.length; ++i3) {
                try {
                    POP3Message pOP3Message = (POP3Message)messageArray[i3];
                    pOP3Message.getHeader("");
                    pOP3Message.getSize();
                    continue;
                }
                catch (MessageRemovedException messageRemovedException) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized String getUID(Message message) throws MessagingException {
        this.checkOpen();
        POP3Message pOP3Message = (POP3Message)message;
        try {
            if (!this.store.supportsUidl) {
                return null;
            }
            if (pOP3Message.uid == "UNKNOWN") {
                pOP3Message.uid = this.port.uidl(pOP3Message.getMessageNumber());
            }
            return pOP3Message.uid;
        }
        catch (EOFException eOFException) {
            this.close(false);
            throw new FolderClosedException((Folder)this, eOFException.toString());
        }
        catch (IOException iOException) {
            throw new MessagingException("error getting UIDL", (Exception)iOException);
        }
    }

    public synchronized int getSize() throws MessagingException {
        this.checkOpen();
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int[] getSizes() throws MessagingException {
        this.checkOpen();
        int[] nArray = new int[this.total];
        InputStream inputStream = null;
        LineInputStream lineInputStream = null;
        try {
            String string;
            inputStream = this.port.list();
            lineInputStream = new LineInputStream(inputStream);
            while ((string = lineInputStream.readLine()) != null) {
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    int n2 = Integer.parseInt(stringTokenizer.nextToken());
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    if (n2 <= 0 || n2 > this.total) continue;
                    nArray[n2 - 1] = n3;
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (lineInputStream != null) {
                    lineInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return nArray;
    }

    public synchronized InputStream listCommand() throws MessagingException, IOException {
        this.checkOpen();
        return this.port.list();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close(false);
    }

    private void checkOpen() throws IllegalStateException {
        if (!this.opened) {
            throw new IllegalStateException("Folder is not Open");
        }
    }

    private void checkClosed() throws IllegalStateException {
        if (this.opened) {
            throw new IllegalStateException("Folder is Open");
        }
    }

    private void checkReadable() throws IllegalStateException {
        if (!this.opened || this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("Folder is not Readable");
        }
    }

    Protocol getProtocol() throws MessagingException {
        Protocol protocol = this.port;
        this.checkOpen();
        return protocol;
    }

    protected void notifyMessageChangedListeners(int n2, Message message) {
        super.notifyMessageChangedListeners(n2, message);
    }

    TempFile getFileCache() {
        return this.fileCache;
    }
}

