/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.imap.protocol;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import macromedia.externals.com.sun.mail_1_4_7.iap.Argument;
import macromedia.externals.javax.mail_1_4_7.Flags;
import macromedia.externals.javax.mail_1_4_7.Message;
import macromedia.externals.javax.mail_1_4_7.search.AddressTerm;
import macromedia.externals.javax.mail_1_4_7.search.AndTerm;
import macromedia.externals.javax.mail_1_4_7.search.BodyTerm;
import macromedia.externals.javax.mail_1_4_7.search.DateTerm;
import macromedia.externals.javax.mail_1_4_7.search.FlagTerm;
import macromedia.externals.javax.mail_1_4_7.search.FromStringTerm;
import macromedia.externals.javax.mail_1_4_7.search.FromTerm;
import macromedia.externals.javax.mail_1_4_7.search.HeaderTerm;
import macromedia.externals.javax.mail_1_4_7.search.MessageIDTerm;
import macromedia.externals.javax.mail_1_4_7.search.NotTerm;
import macromedia.externals.javax.mail_1_4_7.search.OrTerm;
import macromedia.externals.javax.mail_1_4_7.search.ReceivedDateTerm;
import macromedia.externals.javax.mail_1_4_7.search.RecipientStringTerm;
import macromedia.externals.javax.mail_1_4_7.search.RecipientTerm;
import macromedia.externals.javax.mail_1_4_7.search.SearchException;
import macromedia.externals.javax.mail_1_4_7.search.SearchTerm;
import macromedia.externals.javax.mail_1_4_7.search.SentDateTerm;
import macromedia.externals.javax.mail_1_4_7.search.SizeTerm;
import macromedia.externals.javax.mail_1_4_7.search.StringTerm;
import macromedia.externals.javax.mail_1_4_7.search.SubjectTerm;

/*
 * Exception performing whole class analysis ignored.
 */
public class SearchSequence {
    private static String[] monthTable = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    protected Calendar cal = new GregorianCalendar();

    public Argument generateSequence(SearchTerm searchTerm, String string) throws SearchException, IOException {
        if (searchTerm instanceof AndTerm) {
            return this.and((AndTerm)searchTerm, string);
        }
        if (searchTerm instanceof OrTerm) {
            return this.or((OrTerm)searchTerm, string);
        }
        if (searchTerm instanceof NotTerm) {
            return this.not((NotTerm)searchTerm, string);
        }
        if (searchTerm instanceof HeaderTerm) {
            return this.header((HeaderTerm)searchTerm, string);
        }
        if (searchTerm instanceof FlagTerm) {
            return this.flag((FlagTerm)searchTerm);
        }
        if (searchTerm instanceof FromTerm) {
            FromTerm fromTerm = (FromTerm)searchTerm;
            return this.from(fromTerm.getAddress().toString(), string);
        }
        if (searchTerm instanceof FromStringTerm) {
            FromStringTerm fromStringTerm = (FromStringTerm)searchTerm;
            return this.from(fromStringTerm.getPattern(), string);
        }
        if (searchTerm instanceof RecipientTerm) {
            RecipientTerm recipientTerm = (RecipientTerm)searchTerm;
            return this.recipient(recipientTerm.getRecipientType(), recipientTerm.getAddress().toString(), string);
        }
        if (searchTerm instanceof RecipientStringTerm) {
            RecipientStringTerm recipientStringTerm = (RecipientStringTerm)searchTerm;
            return this.recipient(recipientStringTerm.getRecipientType(), recipientStringTerm.getPattern(), string);
        }
        if (searchTerm instanceof SubjectTerm) {
            return this.subject((SubjectTerm)searchTerm, string);
        }
        if (searchTerm instanceof BodyTerm) {
            return this.body((BodyTerm)searchTerm, string);
        }
        if (searchTerm instanceof SizeTerm) {
            return this.size((SizeTerm)searchTerm);
        }
        if (searchTerm instanceof SentDateTerm) {
            return this.sentdate((DateTerm)((SentDateTerm)searchTerm));
        }
        if (searchTerm instanceof ReceivedDateTerm) {
            return this.receiveddate((DateTerm)((ReceivedDateTerm)searchTerm));
        }
        if (searchTerm instanceof MessageIDTerm) {
            return this.messageid((MessageIDTerm)searchTerm, string);
        }
        throw new SearchException("Search too complex");
    }

    public static boolean isAscii(SearchTerm searchTerm) {
        if (searchTerm instanceof AndTerm || searchTerm instanceof OrTerm) {
            SearchTerm[] searchTermArray = searchTerm instanceof AndTerm ? ((AndTerm)searchTerm).getTerms() : ((OrTerm)searchTerm).getTerms();
            for (int i2 = 0; i2 < searchTermArray.length; ++i2) {
                if (SearchSequence.isAscii((SearchTerm)searchTermArray[i2])) continue;
                return false;
            }
        } else {
            if (searchTerm instanceof NotTerm) {
                return SearchSequence.isAscii((SearchTerm)((NotTerm)searchTerm).getTerm());
            }
            if (searchTerm instanceof StringTerm) {
                return SearchSequence.isAscii((String)((StringTerm)searchTerm).getPattern());
            }
            if (searchTerm instanceof AddressTerm) {
                return SearchSequence.isAscii((String)((AddressTerm)searchTerm).getAddress().toString());
            }
        }
        return true;
    }

    public static boolean isAscii(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (string.charAt(i2) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    protected Argument and(AndTerm andTerm, String string) throws SearchException, IOException {
        SearchTerm[] searchTermArray = andTerm.getTerms();
        Argument argument = this.generateSequence(searchTermArray[0], string);
        for (int i2 = 1; i2 < searchTermArray.length; ++i2) {
            argument.append(this.generateSequence(searchTermArray[i2], string));
        }
        return argument;
    }

    protected Argument or(OrTerm orTerm, String string) throws SearchException, IOException {
        SearchTerm searchTerm;
        SearchTerm[] searchTermArray = orTerm.getTerms();
        if (searchTermArray.length > 2) {
            searchTerm = searchTermArray[0];
            for (int i2 = 1; i2 < searchTermArray.length; ++i2) {
                searchTerm = new OrTerm(searchTerm, searchTermArray[i2]);
            }
            orTerm = (OrTerm)searchTerm;
            searchTermArray = orTerm.getTerms();
        }
        searchTerm = new Argument();
        if (searchTermArray.length > 1) {
            searchTerm.writeAtom("OR");
        }
        if (searchTermArray[0] instanceof AndTerm || searchTermArray[0] instanceof FlagTerm) {
            searchTerm.writeArgument(this.generateSequence(searchTermArray[0], string));
        } else {
            searchTerm.append(this.generateSequence(searchTermArray[0], string));
        }
        if (searchTermArray.length > 1) {
            if (searchTermArray[1] instanceof AndTerm || searchTermArray[1] instanceof FlagTerm) {
                searchTerm.writeArgument(this.generateSequence(searchTermArray[1], string));
            } else {
                searchTerm.append(this.generateSequence(searchTermArray[1], string));
            }
        }
        return searchTerm;
    }

    protected Argument not(NotTerm notTerm, String string) throws SearchException, IOException {
        Argument argument = new Argument();
        argument.writeAtom("NOT");
        SearchTerm searchTerm = notTerm.getTerm();
        if (searchTerm instanceof AndTerm || searchTerm instanceof FlagTerm) {
            argument.writeArgument(this.generateSequence(searchTerm, string));
        } else {
            argument.append(this.generateSequence(searchTerm, string));
        }
        return argument;
    }

    protected Argument header(HeaderTerm headerTerm, String string) throws SearchException, IOException {
        Argument argument = new Argument();
        argument.writeAtom("HEADER");
        argument.writeString(headerTerm.getHeaderName());
        argument.writeString(headerTerm.getPattern(), string);
        return argument;
    }

    protected Argument messageid(MessageIDTerm messageIDTerm, String string) throws SearchException, IOException {
        Argument argument = new Argument();
        argument.writeAtom("HEADER");
        argument.writeString("Message-ID");
        argument.writeString(messageIDTerm.getPattern(), string);
        return argument;
    }

    protected Argument flag(FlagTerm flagTerm) throws SearchException {
        int n2;
        boolean bl2 = flagTerm.getTestSet();
        Argument argument = new Argument();
        Flags flags = flagTerm.getFlags();
        Flags.Flag[] flagArray = flags.getSystemFlags();
        String[] stringArray = flags.getUserFlags();
        if (flagArray.length == 0 && stringArray.length == 0) {
            throw new SearchException("Invalid FlagTerm");
        }
        for (n2 = 0; n2 < flagArray.length; ++n2) {
            if (flagArray[n2] == Flags.Flag.DELETED) {
                argument.writeAtom(bl2 ? "DELETED" : "UNDELETED");
                continue;
            }
            if (flagArray[n2] == Flags.Flag.ANSWERED) {
                argument.writeAtom(bl2 ? "ANSWERED" : "UNANSWERED");
                continue;
            }
            if (flagArray[n2] == Flags.Flag.DRAFT) {
                argument.writeAtom(bl2 ? "DRAFT" : "UNDRAFT");
                continue;
            }
            if (flagArray[n2] == Flags.Flag.FLAGGED) {
                argument.writeAtom(bl2 ? "FLAGGED" : "UNFLAGGED");
                continue;
            }
            if (flagArray[n2] == Flags.Flag.RECENT) {
                argument.writeAtom(bl2 ? "RECENT" : "OLD");
                continue;
            }
            if (flagArray[n2] != Flags.Flag.SEEN) continue;
            argument.writeAtom(bl2 ? "SEEN" : "UNSEEN");
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            argument.writeAtom(bl2 ? "KEYWORD" : "UNKEYWORD");
            argument.writeAtom(stringArray[n2]);
        }
        return argument;
    }

    protected Argument from(String string, String string2) throws SearchException, IOException {
        Argument argument = new Argument();
        argument.writeAtom("FROM");
        argument.writeString(string, string2);
        return argument;
    }

    protected Argument recipient(Message.RecipientType recipientType, String string, String string2) throws SearchException, IOException {
        Argument argument = new Argument();
        if (recipientType == Message.RecipientType.TO) {
            argument.writeAtom("TO");
        } else if (recipientType == Message.RecipientType.CC) {
            argument.writeAtom("CC");
        } else if (recipientType == Message.RecipientType.BCC) {
            argument.writeAtom("BCC");
        } else {
            throw new SearchException("Illegal Recipient type");
        }
        argument.writeString(string, string2);
        return argument;
    }

    protected Argument subject(SubjectTerm subjectTerm, String string) throws SearchException, IOException {
        Argument argument = new Argument();
        argument.writeAtom("SUBJECT");
        argument.writeString(subjectTerm.getPattern(), string);
        return argument;
    }

    protected Argument body(BodyTerm bodyTerm, String string) throws SearchException, IOException {
        Argument argument = new Argument();
        argument.writeAtom("BODY");
        argument.writeString(bodyTerm.getPattern(), string);
        return argument;
    }

    protected Argument size(SizeTerm sizeTerm) throws SearchException {
        Argument argument = new Argument();
        switch (sizeTerm.getComparison()) {
            case 5: {
                argument.writeAtom("LARGER");
                break;
            }
            case 2: {
                argument.writeAtom("SMALLER");
                break;
            }
            default: {
                throw new SearchException("Cannot handle Comparison");
            }
        }
        argument.writeNumber(sizeTerm.getNumber());
        return argument;
    }

    protected String toIMAPDate(Date date) {
        StringBuffer stringBuffer = new StringBuffer();
        this.cal.setTime(date);
        stringBuffer.append(this.cal.get(5)).append("-");
        stringBuffer.append(monthTable[this.cal.get(2)]).append('-');
        stringBuffer.append(this.cal.get(1));
        return stringBuffer.toString();
    }

    protected Argument sentdate(DateTerm dateTerm) throws SearchException {
        Argument argument = new Argument();
        String string = this.toIMAPDate(dateTerm.getDate());
        switch (dateTerm.getComparison()) {
            case 5: {
                argument.writeAtom(new StringBuffer().append("SENTSINCE ").append(string).toString());
                break;
            }
            case 3: {
                argument.writeAtom(new StringBuffer().append("SENTON ").append(string).toString());
                break;
            }
            case 2: {
                argument.writeAtom(new StringBuffer().append("SENTBEFORE ").append(string).toString());
                break;
            }
            case 6: {
                argument.writeAtom(new StringBuffer().append("OR SENTSINCE ").append(string).append(" SENTON ").append(string).toString());
                break;
            }
            case 1: {
                argument.writeAtom(new StringBuffer().append("OR SENTBEFORE ").append(string).append(" SENTON ").append(string).toString());
                break;
            }
            case 4: {
                argument.writeAtom(new StringBuffer().append("NOT SENTON ").append(string).toString());
                break;
            }
            default: {
                throw new SearchException("Cannot handle Date Comparison");
            }
        }
        return argument;
    }

    protected Argument receiveddate(DateTerm dateTerm) throws SearchException {
        Argument argument = new Argument();
        String string = this.toIMAPDate(dateTerm.getDate());
        switch (dateTerm.getComparison()) {
            case 5: {
                argument.writeAtom(new StringBuffer().append("SINCE ").append(string).toString());
                break;
            }
            case 3: {
                argument.writeAtom(new StringBuffer().append("ON ").append(string).toString());
                break;
            }
            case 2: {
                argument.writeAtom(new StringBuffer().append("BEFORE ").append(string).toString());
                break;
            }
            case 6: {
                argument.writeAtom(new StringBuffer().append("OR SINCE ").append(string).append(" ON ").append(string).toString());
                break;
            }
            case 1: {
                argument.writeAtom(new StringBuffer().append("OR BEFORE ").append(string).append(" ON ").append(string).toString());
                break;
            }
            case 4: {
                argument.writeAtom(new StringBuffer().append("NOT ON ").append(string).toString());
                break;
            }
            default: {
                throw new SearchException("Cannot handle Date Comparison");
            }
        }
        return argument;
    }
}

