/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.imap.protocol;

import macromedia.externals.com.sun.mail_1_4_7.iap.ParsingException;
import macromedia.externals.com.sun.mail_1_4_7.iap.Response;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.FLAGS;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.IMAPResponse;
import macromedia.externals.javax.mail_1_4_7.Flags;

public class MailboxInfo {
    public Flags availableFlags = null;
    public Flags permanentFlags = null;
    public int total = -1;
    public int recent = -1;
    public int first = -1;
    public long uidvalidity = -1L;
    public long uidnext = -1L;
    public int mode;

    public MailboxInfo(Response[] responseArray) throws ParsingException {
        for (int i2 = 0; i2 < responseArray.length; ++i2) {
            if (responseArray[i2] == null || !(responseArray[i2] instanceof IMAPResponse)) continue;
            IMAPResponse iMAPResponse = (IMAPResponse)responseArray[i2];
            if (iMAPResponse.keyEquals("EXISTS")) {
                this.total = iMAPResponse.getNumber();
                responseArray[i2] = null;
                continue;
            }
            if (iMAPResponse.keyEquals("RECENT")) {
                this.recent = iMAPResponse.getNumber();
                responseArray[i2] = null;
                continue;
            }
            if (iMAPResponse.keyEquals("FLAGS")) {
                this.availableFlags = new FLAGS(iMAPResponse);
                responseArray[i2] = null;
                continue;
            }
            if (!iMAPResponse.isUnTagged() || !iMAPResponse.isOK()) continue;
            iMAPResponse.skipSpaces();
            if (iMAPResponse.readByte() != 91) {
                iMAPResponse.reset();
                continue;
            }
            boolean bl2 = true;
            String string = iMAPResponse.readAtom();
            if (string.equalsIgnoreCase("UNSEEN")) {
                this.first = iMAPResponse.readNumber();
            } else if (string.equalsIgnoreCase("UIDVALIDITY")) {
                this.uidvalidity = iMAPResponse.readLong();
            } else if (string.equalsIgnoreCase("PERMANENTFLAGS")) {
                this.permanentFlags = new FLAGS(iMAPResponse);
            } else if (string.equalsIgnoreCase("UIDNEXT")) {
                this.uidnext = iMAPResponse.readLong();
            } else {
                bl2 = false;
            }
            if (bl2) {
                responseArray[i2] = null;
                continue;
            }
            iMAPResponse.reset();
        }
        if (this.permanentFlags == null) {
            this.permanentFlags = this.availableFlags != null ? new Flags(this.availableFlags) : new Flags();
        }
    }
}

