/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.imap.protocol;

import java.util.Date;
import java.util.Vector;
import macromedia.externals.com.sun.mail_1_4_7.iap.ParsingException;
import macromedia.externals.com.sun.mail_1_4_7.iap.Response;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.FetchResponse;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.IMAPAddress;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.Item;
import macromedia.externals.javax.mail_1_4_7.internet.InternetAddress;
import macromedia.externals.javax.mail_1_4_7.internet.MailDateFormat;

public class ENVELOPE
implements Item {
    static final char[] name = new char[]{'E', 'N', 'V', 'E', 'L', 'O', 'P', 'E'};
    public int msgno;
    public Date date = null;
    public String subject;
    public InternetAddress[] from;
    public InternetAddress[] sender;
    public InternetAddress[] replyTo;
    public InternetAddress[] to;
    public InternetAddress[] cc;
    public InternetAddress[] bcc;
    public String inReplyTo;
    public String messageId;
    private static MailDateFormat mailDateFormat = new MailDateFormat();

    public ENVELOPE(FetchResponse fetchResponse) throws ParsingException {
        this.msgno = fetchResponse.getNumber();
        fetchResponse.skipSpaces();
        if (fetchResponse.readByte() != 40) {
            throw new ParsingException("ENVELOPE parse error");
        }
        String string = fetchResponse.readString();
        if (string != null) {
            try {
                this.date = mailDateFormat.parse(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.subject = fetchResponse.readString();
        this.from = this.parseAddressList((Response)fetchResponse);
        this.sender = this.parseAddressList((Response)fetchResponse);
        this.replyTo = this.parseAddressList((Response)fetchResponse);
        this.to = this.parseAddressList((Response)fetchResponse);
        this.cc = this.parseAddressList((Response)fetchResponse);
        this.bcc = this.parseAddressList((Response)fetchResponse);
        this.inReplyTo = fetchResponse.readString();
        this.messageId = fetchResponse.readString();
        if (fetchResponse.readByte() != 41) {
            throw new ParsingException("ENVELOPE parse error");
        }
    }

    private InternetAddress[] parseAddressList(Response response) throws ParsingException {
        response.skipSpaces();
        byte by2 = response.readByte();
        if (by2 == 40) {
            Object[] objectArray;
            Vector<Object[]> vector = new Vector<Object[]>();
            do {
                if ((objectArray = new IMAPAddress(response)).isEndOfGroup()) continue;
                vector.addElement(objectArray);
            } while (response.peekByte() != 41);
            response.skip(1);
            objectArray = new InternetAddress[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        if (by2 == 78 || by2 == 110) {
            response.skip(2);
            return null;
        }
        throw new ParsingException("ADDRESS parse error");
    }
}

